/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.contrib.ids;

import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.contrib.ids.IdDocument;

public class IdAttribute
extends Attribute {
    public IdAttribute(String name, String value, Namespace namespace) {
        super(name, value, namespace);
    }

    public IdAttribute(String name, String value, int type, Namespace namespace) {
        super(name, value, type, namespace);
    }

    public IdAttribute(String name, String value) {
        this(name, value, 0, Namespace.NO_NAMESPACE);
    }

    public IdAttribute(String name, String value, int type) {
        this(name, value, type, Namespace.NO_NAMESPACE);
    }

    protected Attribute setParent(Element parent) {
        Element oldParent = this.getParent();
        super.setParent(parent);
        if (this.getAttributeType() == 2) {
            Document doc;
            if (oldParent != null && (doc = oldParent.getDocument()) instanceof IdDocument) {
                ((IdDocument)doc).removeId(this.getValue());
            }
            if ((doc = this.getDocument()) instanceof IdDocument) {
                ((IdDocument)doc).addId(this.getValue(), this.getParent());
            }
        }
        return this;
    }

    public Attribute setValue(String value) {
        Document doc;
        String oldValue = this.getValue();
        super.setValue(value);
        if (this.getAttributeType() == 2 && (doc = this.getDocument()) instanceof IdDocument) {
            ((IdDocument)doc).removeId(oldValue);
            ((IdDocument)doc).addId(this.getValue(), this.getParent());
        }
        return this;
    }

    public Attribute setAttributeType(int type) {
        int oldType = this.getAttributeType();
        if (type != oldType) {
            super.setAttributeType(type);
            Document doc = this.getDocument();
            if (doc instanceof IdDocument) {
                if (oldType == 2) {
                    ((IdDocument)doc).removeId(this.getValue());
                }
                if (type == 2) {
                    ((IdDocument)doc).addId(this.getValue(), this.getParent());
                }
            }
        }
        return this;
    }
}

