/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class Ident {
    private static final int KDELIM = 36;
    private static final int VDELIM = 58;
    private static final String[] rcsTags = new String[]{"Author", "Date", "Header", "Id", "Locker", "Log", "Name", "RCSfile", "Revision", "Source", "State"};
    private static final HashMap tagMap = new HashMap();

    public static void main(String[] args) throws IOException {
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                System.out.println(args[i] + ":");
                if (Ident.isZip(args[i])) {
                    ZipFile zipFile = new ZipFile(args[i]);
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry ze = entries.nextElement();
                        System.out.println("   ->" + ze.getName() + "<-");
                        Ident.scan(zipFile.getInputStream(ze));
                    }
                    continue;
                }
                FileInputStream fis = new FileInputStream(args[i]);
                Ident.scan(fis);
            }
        } else {
            Ident.printUsage();
        }
    }

    private static void printUsage() {
        System.out.println("This program prints RCS information about a class file.");
        System.out.println("Usage: java Ident [classfile.class | jarfile.jar]");
    }

    private static boolean isZip(String fileName) {
        return fileName.endsWith(".jar") || fileName.endsWith(".zip");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void scan(InputStream is) throws IOException {
        int i = 0;
        StringBuffer sb = new StringBuffer();
        boolean inTag = false;
        boolean validTag = false;
        while (true) {
            block9: {
                if ((i = is.read()) == -1) {
                    return;
                }
                if (i == 36) {
                    if (inTag) {
                        if (validTag) {
                            System.out.println("     $" + sb.toString() + "$");
                        }
                        inTag = false;
                        validTag = false;
                        sb = new StringBuffer();
                        break block9;
                    } else {
                        inTag = true;
                        continue;
                    }
                }
                if (i == 58 && inTag && !validTag) {
                    String tag = sb.toString();
                    if (tagMap.get(tag) == null) {
                        inTag = false;
                        validTag = false;
                        sb = new StringBuffer();
                    } else {
                        validTag = true;
                    }
                }
            }
            if (!inTag) continue;
            sb.append((char)i);
        }
    }

    static {
        for (int i = 0; i < rcsTags.length; ++i) {
            tagMap.put(rcsTags[i], rcsTags[i]);
        }
    }
}

