/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.vavr;

import io.vavr.Lazy;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.Array;
import io.vavr.collection.HashMap;
import io.vavr.collection.HashMultimap;
import io.vavr.collection.HashSet;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.LinkedHashMultimap;
import io.vavr.collection.LinkedHashSet;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Multimap;
import io.vavr.collection.PriorityQueue;
import io.vavr.collection.Queue;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.collection.SortedMap;
import io.vavr.collection.SortedMultimap;
import io.vavr.collection.SortedSet;
import io.vavr.collection.Stream;
import io.vavr.collection.Traversable;
import io.vavr.collection.TreeMap;
import io.vavr.collection.TreeMultimap;
import io.vavr.collection.TreeSet;
import io.vavr.collection.Vector;
import io.vavr.control.Option;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.stream.Collector;
import org.jdbi.v3.core.collector.CollectorFactory;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.vavr.VavrCollectors;

class VavrCollectorFactory
implements CollectorFactory {
    private final Map<Class<?>, Class<?>> defaultImplementations = HashMap.of(Traversable.class, List.class, Seq.class, Vector.class, IndexedSeq.class, Vector.class, LinearSeq.class, List.class, Set.class, HashSet.class, SortedSet.class, TreeSet.class, Map.class, HashMap.class, SortedMap.class, TreeMap.class, Multimap.class, HashMultimap.class, SortedMultimap.class, TreeMultimap.class);
    private final Map<Class<?>, Collector<?, ?, ?>> collectors = HashMap.ofEntries((Tuple2[])new Tuple2[]{Tuple.of(Option.class, VavrCollectors.toOption()), Tuple.of(Array.class, (Object)Array.collector()), Tuple.of(Vector.class, (Object)Vector.collector()), Tuple.of(List.class, (Object)List.collector()), Tuple.of(Stream.class, (Object)Stream.collector()), Tuple.of(Queue.class, (Object)Queue.collector()), Tuple.of(PriorityQueue.class, (Object)PriorityQueue.collector()), Tuple.of(HashSet.class, (Object)HashSet.collector()), Tuple.of(LinkedHashSet.class, (Object)LinkedHashSet.collector()), Tuple.of(TreeSet.class, (Object)TreeSet.collector()), Tuple.of(HashMap.class, (Object)HashMap.collector()), Tuple.of(LinkedHashMap.class, (Object)LinkedHashMap.collector()), Tuple.of(TreeMap.class, (Object)TreeMap.collector()), Tuple.of(HashMultimap.class, (Object)HashMultimap.withSeq().collector()), Tuple.of(LinkedHashMultimap.class, (Object)LinkedHashMultimap.withSeq().collector()), Tuple.of(TreeMultimap.class, (Object)TreeMultimap.withSeq().collector())});

    VavrCollectorFactory() {
    }

    public boolean accepts(Type containerType) {
        Class<?> erasedType = this.getCollectionType(containerType);
        boolean hasCollector = this.collectors.containsKey(erasedType);
        return (hasCollector || this.hasDefaultImplementationWithCollector(erasedType)) && containerType instanceof ParameterizedType;
    }

    private Class<?> getCollectionType(Type containerType) {
        return GenericTypes.getErasedType((Type)containerType);
    }

    private boolean hasDefaultImplementationWithCollector(Class<?> erasedType) {
        return this.resolveDefaultCollector(erasedType).isDefined();
    }

    private Option<Collector<?, ?, ?>> resolveDefaultCollector(Class<?> erasedType) {
        return this.defaultImplementations.get(erasedType).flatMap(arg_0 -> this.collectors.get(arg_0));
    }

    public Optional<Type> elementType(Type containerType) {
        Class<?> erasedType = this.getCollectionType(containerType);
        if (Map.class.isAssignableFrom(erasedType)) {
            return Optional.of(VavrCollectorFactory.resolveMaplikeEntryType(containerType, Map.class));
        }
        if (Multimap.class.isAssignableFrom(erasedType)) {
            return Optional.of(VavrCollectorFactory.resolveMaplikeEntryType(containerType, Multimap.class));
        }
        return GenericTypes.findGenericParameter((Type)containerType, erasedType);
    }

    public Collector<?, ?, ?> build(Type containerType) {
        Class<?> erasedType = this.getCollectionType(containerType);
        return (Collector)this.collectors.getOrElse(erasedType, Lazy.val(() -> (Collector)this.resolveDefaultCollector(erasedType).get(), Collector.class));
    }

    private static Type resolveMaplikeEntryType(Type maplikeType, Class<?> maplikeClass) {
        Type keyType = (Type)((Object)GenericTypes.findGenericParameter((Type)maplikeType, maplikeClass, (int)0).orElse(Object.class));
        Type valueType = (Type)((Object)GenericTypes.findGenericParameter((Type)maplikeType, maplikeClass, (int)1).orElse(Object.class));
        return GenericTypes.parameterizeClass(Tuple2.class, (Type[])new Type[]{keyType, valueType});
    }
}

