/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.vavr;

import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.mapper.MapEntryConfig;
import org.jdbi.v3.core.mapper.MapEntryMappers;

public class TupleMappers
implements JdbiConfig<TupleMappers>,
MapEntryConfig<TupleMappers> {
    private static final int KEY_COLUMN_TUPLE_INDEX = 1;
    private static final int VALUE_COLUMN_TUPLE_INDEX = 2;
    private ConfigRegistry registry;
    private final String[] columns = new String[8];

    public TupleMappers() {
    }

    private TupleMappers(TupleMappers that) {
        System.arraycopy(that.columns, 0, this.columns, 0, 8);
    }

    public String getKeyColumn() {
        String column = this.getColumn(1);
        if (column == null) {
            return ((MapEntryMappers)this.registry.get(MapEntryMappers.class)).getKeyColumn();
        }
        return column;
    }

    public TupleMappers setKeyColumn(String keyColumn) {
        return this.setColumn(1, keyColumn);
    }

    public String getValueColumn() {
        String column = this.getColumn(2);
        if (column == null) {
            return ((MapEntryMappers)this.registry.get(MapEntryMappers.class)).getValueColumn();
        }
        return column;
    }

    public TupleMappers setValueColumn(String valueColumn) {
        return this.setColumn(2, valueColumn);
    }

    public TupleMappers setColumn(int tupleIndex, String name) {
        this.columns[tupleIndex - 1] = name;
        return this;
    }

    public String getColumn(int tupleIndex) {
        return this.columns[tupleIndex - 1];
    }

    public TupleMappers createCopy() {
        return new TupleMappers(this);
    }

    public void setRegistry(ConfigRegistry registry) {
        this.registry = registry;
    }
}

