/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.vavr;

import io.vavr.Lazy;
import io.vavr.Value;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import io.vavr.control.Validation;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;

class VavrValueArgumentFactory
implements ArgumentFactory.Preparable {
    private static final Class<?>[] VALUE_CLASSES = new Class[]{Option.class, Lazy.class, Try.class, Either.class, Validation.class};
    private static final Supplier<Type> OBJECT_SUPPLIER = () -> Object.class;

    VavrValueArgumentFactory() {
    }

    public Optional<Argument> build(Type type, Object value, ConfigRegistry config) {
        if (VavrValueArgumentFactory.acceptType(type)) {
            Object nestedValue = VavrValueArgumentFactory.unwrapValue((Value)value);
            Type nestedType = VavrValueArgumentFactory.findGenericType(type, nestedValue);
            return ((Arguments)config.get(Arguments.class)).findFor(nestedType, nestedValue);
        }
        return Optional.empty();
    }

    public Optional<Function<Object, Argument>> prepare(Type type, ConfigRegistry config) {
        if (VavrValueArgumentFactory.acceptType(type)) {
            return ((Arguments)config.get(Arguments.class)).prepareFor(VavrValueArgumentFactory.findGenericType(type, null)).map(argumentFunction -> value -> (Argument)argumentFunction.apply(VavrValueArgumentFactory.unwrapValue((Value)value)));
        }
        return Optional.empty();
    }

    private static boolean acceptType(Type type) {
        Class rawType = GenericTypes.getErasedType((Type)type);
        for (Class<?> valueClass : VALUE_CLASSES) {
            if (!valueClass.isAssignableFrom(rawType)) continue;
            return true;
        }
        return false;
    }

    private static Type findGenericType(Type wrapperType, Object nestedValue) {
        Optional nestedType = GenericTypes.findGenericParameter((Type)wrapperType, Value.class);
        return nestedType.orElseGet(VavrValueArgumentFactory.typeFromValue(nestedValue));
    }

    private static Supplier<Type> typeFromValue(Object object) {
        return object == null ? OBJECT_SUPPLIER : object::getClass;
    }

    private static Object unwrapValue(Value<?> value) {
        return value == null ? null : value.getOrNull();
    }
}

