/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.vavr;

import io.vavr.CheckedFunction1;
import io.vavr.Tuple;
import io.vavr.Tuple0;
import io.vavr.Tuple1;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.Tuple4;
import io.vavr.Tuple5;
import io.vavr.Tuple6;
import io.vavr.Tuple7;
import io.vavr.Tuple8;
import io.vavr.collection.Array;
import io.vavr.control.Option;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.Optional;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.ColumnMappers;
import org.jdbi.v3.core.mapper.NoSuchMapperException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.jdbi.v3.core.mapper.RowMappers;
import org.jdbi.v3.core.mapper.SingleColumnMapper;
import org.jdbi.v3.vavr.TupleMappers;

class VavrTupleRowMapperFactory
implements RowMapperFactory {
    VavrTupleRowMapperFactory() {
    }

    public Optional<RowMapper<?>> build(Type type, ConfigRegistry config) {
        boolean mappableTupleType;
        Class erasedType = GenericTypes.getErasedType((Type)type);
        boolean emptyTupleType = Tuple0.class.equals((Object)erasedType) || Tuple.class.equals((Object)erasedType);
        boolean bl = mappableTupleType = type instanceof ParameterizedType && Tuple.class.isAssignableFrom(erasedType);
        if (mappableTupleType && !emptyTupleType) {
            Class tupleClass = erasedType;
            Array tupleTypes = Array.of((Object[])tupleClass.getTypeParameters()).map(tp -> GenericTypes.resolveType((Type)tp, (Type)type)).zipWithIndex((t, i) -> Tuple.of((Object)t, (Object)(i + 1)));
            Array withConfiguredColumnName = Tuple2.class.equals((Object)erasedType) ? this.resolveKeyValueColumns(config, (Array<Tuple2<Type, Integer>>)tupleTypes) : tupleTypes.map(t -> Tuple.of((Object)((Type)t._1), (Object)((Integer)t._2), this.getConfiguredColumnName((Integer)t._2, config)));
            boolean anyColumnSet = withConfiguredColumnName.map(t -> (Option)t._3).exists(Option::isDefined);
            if (anyColumnSet) {
                Array mappers = withConfiguredColumnName.map(t -> ((Option)t._3).isDefined() ? this.getColumnMapperForDefinedColumn((Type)t._1, (String)((Option)t._3).get(), config) : this.getRowMapper((Type)t._1, config));
                boolean mappableWithConfigured = mappers.forAll(Optional::isPresent);
                if (mappableWithConfigured) {
                    return this.buildMapper(tupleClass, mappers);
                }
                Array configuredColumns = withConfiguredColumnName.map(t -> t._2 + ": " + (String)((Option)t._3).getOrNull());
                throw new NoSuchMapperException(type + " cannot be mapped. If tuple columns are configured (TupleMappers config class), each tuple entry must be mappable via specified column name or existing RowMapper. Currently configured: " + configuredColumns.mkString((CharSequence)", "));
            }
            Array colMappers = tupleTypes.map(t -> this.getColumnMapper((Type)t._1, (Integer)t._2, config));
            boolean mappableByColumn = colMappers.forAll(Optional::isPresent);
            if (mappableByColumn) {
                return this.buildMapper(tupleClass, colMappers);
            }
            Array rowMappers = tupleTypes.map(t -> this.getRowMapper((Type)t._1, config));
            boolean mappableByRowMappers = rowMappers.forAll(Optional::isPresent);
            if (mappableByRowMappers) {
                return this.buildMapper(tupleClass, rowMappers);
            }
            throw new NoSuchMapperException(type + " cannot be mapped. All tuple elements must be mappable by ColumnMapper or all by RowMapper. If you want to mix column- and rowmapped entries, you must configure columns via TupleMappers config class");
        }
        return Optional.empty();
    }

    Array<Tuple3<Type, Integer, Option<String>>> resolveKeyValueColumns(ConfigRegistry config, Array<Tuple2<Type, Integer>> tupleTypes) {
        Tuple2 keyType = (Tuple2)tupleTypes.get(0);
        Tuple2 valueType = (Tuple2)tupleTypes.get(1);
        Array withConfiguredColumnName = Array.of((Object[])new Tuple3[]{Tuple.of((Object)((Type)keyType._1), (Object)((Integer)keyType._2), (Object)Option.of((Object)((TupleMappers)config.get(TupleMappers.class)).getKeyColumn())), Tuple.of((Object)((Type)valueType._1), (Object)((Integer)valueType._2), (Object)Option.of((Object)((TupleMappers)config.get(TupleMappers.class)).getValueColumn()))});
        return withConfiguredColumnName;
    }

    private Optional<RowMapper<?>> buildMapper(Class<? extends Tuple> tupleClass, Array<Optional<RowMapper<?>>> colMappers) {
        Array cms = colMappers.map(Optional::get);
        return Optional.of((rs, ctx) -> this.buildTuple(tupleClass, (MapperValueResolver & Serializable)i -> ((RowMapper)cms.get(i.intValue())).map(rs, ctx)));
    }

    private Tuple buildTuple(Class<? extends Tuple> tupleClass, MapperValueResolver r) throws SQLException {
        if (Tuple1.class.equals(tupleClass)) {
            return Tuple.of((Object)r.apply(0));
        }
        if (Tuple2.class.equals(tupleClass)) {
            return Tuple.of((Object)r.apply(0), (Object)r.apply(1));
        }
        if (Tuple3.class.equals(tupleClass)) {
            return Tuple.of((Object)r.apply(0), (Object)r.apply(1), (Object)r.apply(2));
        }
        if (Tuple4.class.equals(tupleClass)) {
            return Tuple.of((Object)r.apply(0), (Object)r.apply(1), (Object)r.apply(2), (Object)r.apply(3));
        }
        if (Tuple5.class.equals(tupleClass)) {
            return Tuple.of((Object)r.apply(0), (Object)r.apply(1), (Object)r.apply(2), (Object)r.apply(3), (Object)r.apply(4));
        }
        if (Tuple6.class.equals(tupleClass)) {
            return Tuple.of((Object)r.apply(0), (Object)r.apply(1), (Object)r.apply(2), (Object)r.apply(3), (Object)r.apply(4), (Object)r.apply(5));
        }
        if (Tuple7.class.equals(tupleClass)) {
            return Tuple.of((Object)r.apply(0), (Object)r.apply(1), (Object)r.apply(2), (Object)r.apply(3), (Object)r.apply(4), (Object)r.apply(5), (Object)r.apply(6));
        }
        if (Tuple8.class.equals(tupleClass)) {
            return Tuple.of((Object)r.apply(0), (Object)r.apply(1), (Object)r.apply(2), (Object)r.apply(3), (Object)r.apply(4), (Object)r.apply(5), (Object)r.apply(6), (Object)r.apply(7));
        }
        throw new IllegalArgumentException("unknown tuple type " + tupleClass);
    }

    Optional<RowMapper<?>> getColumnMapper(Type type, int tupleIndex, ConfigRegistry config) {
        int colIndex = tupleIndex;
        return ((ColumnMappers)config.get(ColumnMappers.class)).findFor(type).map(cm -> new SingleColumnMapper(cm, colIndex));
    }

    private Optional<RowMapper<?>> getRowMapper(Type type, ConfigRegistry config) {
        return ((RowMappers)config.get(RowMappers.class)).findFor(type);
    }

    private Optional<RowMapper<?>> getColumnMapperForDefinedColumn(Type type, String col, ConfigRegistry config) {
        return ((ColumnMappers)config.get(ColumnMappers.class)).findFor(type).map(cm -> new SingleColumnMapper(cm, col));
    }

    Option<String> getConfiguredColumnName(int tupleIndex, ConfigRegistry config) {
        return Option.of((Object)((TupleMappers)config.get(TupleMappers.class)).getColumn(tupleIndex));
    }

    private static interface MapperValueResolver
    extends CheckedFunction1<Integer, Object> {
        public Object apply(Integer var1) throws SQLException;
    }
}

