/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.vavr;

import io.vavr.Lazy;
import io.vavr.Value;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import io.vavr.control.Validation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;

class VavrValueArgumentFactory
implements ArgumentFactory {
    private static final Set<Class<?>> VALUE_CLASSES = new HashSet<Class>(Arrays.asList(Option.class, Lazy.class, Try.class, Either.class, Validation.class));

    VavrValueArgumentFactory() {
    }

    public Optional<Argument> build(Type type, Object value, ConfigRegistry config) {
        Class rawType = GenericTypes.getErasedType((Type)type);
        if (VALUE_CLASSES.stream().anyMatch(vc -> vc.isAssignableFrom(rawType))) {
            return VavrValueArgumentFactory.buildValueArgument(type, config, (Value)value);
        }
        return Optional.empty();
    }

    private static Optional<Argument> buildValueArgument(Type type, ConfigRegistry config, Value<?> value) {
        Type nestedType = GenericTypes.findGenericParameter((Type)type, Value.class).orElseGet(() -> VavrValueArgumentFactory.extractTypeOfValue(value));
        Object nestedValue = value == null ? null : value.getOrNull();
        return ((Arguments)config.get(Arguments.class)).findFor(nestedType, nestedValue);
    }

    private static Type extractTypeOfValue(Value<?> value) {
        Value classOfValue = value.map(Object::getClass);
        return (Type)classOfValue.getOrElse(Object.class);
    }
}

