/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.vavr;

import io.vavr.control.Option;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.core.mapper.NoSuchMapperException;
import org.jdbi.v3.core.statement.StatementContext;

class VavrOptionMapper<T>
implements ColumnMapper<Option<T>> {
    private final Type nestedType;

    private VavrOptionMapper(Type nestedType) {
        this.nestedType = nestedType;
    }

    static ColumnMapperFactory factory() {
        return (type, config) -> {
            Class rawType = GenericTypes.getErasedType((Type)type);
            if (rawType == Option.class) {
                Type nestedType = (Type)GenericTypes.findGenericParameter((Type)type, Option.class).orElseThrow(() -> new NoSuchMapperException("No mapper for raw Option type"));
                return Optional.of(new VavrOptionMapper(nestedType));
            }
            return Optional.empty();
        };
    }

    public Option<T> map(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        ColumnMapper mapper = (ColumnMapper)ctx.findColumnMapperFor(this.nestedType).orElseThrow(() -> new NoSuchMapperException("No mapper for type " + this.nestedType + " nested in Option"));
        return Option.of((Object)mapper.map(r, columnNumber, ctx));
    }
}

