/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.vavr;

import io.vavr.Lazy;
import io.vavr.Value;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import io.vavr.control.Validation;
import java.lang.reflect.Type;
import java.util.Optional;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;

class VavrValueArgumentFactory
implements ArgumentFactory {
    VavrValueArgumentFactory() {
    }

    public Optional<Argument> build(Type type, Object value, ConfigRegistry config) {
        if (value instanceof Option || value instanceof Lazy || value instanceof Try || value instanceof Either || value instanceof Validation) {
            return this.buildValueArgument(type, config, (Value)value);
        }
        return Optional.empty();
    }

    private Optional<Argument> buildValueArgument(Type type, ConfigRegistry config, Value<?> value) {
        Type nestedType = GenericTypes.findGenericParameter((Type)type, Value.class).orElseGet(() -> this.extractTypeOfValue(value));
        Object nestedValue = value.getOrNull();
        return this.resolveNestedFromConfigured(config, nestedType, nestedValue);
    }

    Optional<Argument> resolveNestedFromConfigured(ConfigRegistry config, Type nestedType, Object nestedValue) {
        return ((Arguments)config.get(Arguments.class)).findFor(nestedType, nestedValue);
    }

    private Type extractTypeOfValue(Value<?> value) {
        Value classOfValue = value.map(Object::getClass);
        return (Type)classOfValue.getOrElse(Object.class);
    }
}

