/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.vavr;

import io.vavr.Tuple2;
import io.vavr.collection.Map;
import io.vavr.collection.Multimap;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.generic.internal.TypeParameter;
import org.jdbi.v3.core.generic.internal.TypeToken;

class VavrGenericMapUtil {
    private static final TypeVariable<Class<Map>> KEY;
    private static final TypeVariable<Class<Map>> VALUE;
    private static final TypeVariable<Class<Multimap>> KEY_MULTIMAP;
    private static final TypeVariable<Class<Multimap>> VALUE_MULTIMAP;

    VavrGenericMapUtil() {
    }

    static Type resolveMapEntryType(Type mapType) {
        return VavrGenericMapUtil.resolveMaplikeEntryType(mapType, KEY, VALUE);
    }

    static Type resolveMultimapEntryType(Type mapType) {
        return VavrGenericMapUtil.resolveMaplikeEntryType(mapType, KEY_MULTIMAP, VALUE_MULTIMAP);
    }

    private static Type resolveMaplikeEntryType(Type maplikeType, Type keyParam, Type valueParam) {
        Type keyType = GenericTypes.resolveType((Type)keyParam, (Type)maplikeType);
        Type valueType = GenericTypes.resolveType((Type)valueParam, (Type)maplikeType);
        return VavrGenericMapUtil.resolveMapEntryType(keyType, valueType);
    }

    private static Type resolveMapEntryType(Type keyType, Type valueType) {
        return VavrGenericMapUtil.resolveMapEntryType(TypeToken.of((Type)keyType), TypeToken.of((Type)valueType));
    }

    private static <K, V> Type resolveMapEntryType(TypeToken<K> keyType, TypeToken<V> valueType) {
        return new TypeToken<Tuple2<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType).getType();
    }

    static {
        TypeVariable<Class<T>>[] mapParams = Map.class.getTypeParameters();
        KEY = mapParams[0];
        VALUE = mapParams[1];
        TypeVariable<Class<T>>[] multimapParams = Multimap.class.getTypeParameters();
        KEY_MULTIMAP = multimapParams[0];
        VALUE_MULTIMAP = multimapParams[1];
    }
}

