/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.testing.EmbeddedH2JdbiRule;
import org.jdbi.v3.testing.EmbeddedPostgresJdbiRule;
import org.jdbi.v3.testing.ExternalPostgresJdbiRule;
import org.jdbi.v3.testing.Migration;
import org.junit.rules.ExternalResource;

public abstract class JdbiRule
extends ExternalResource {
    private final List<JdbiPlugin> plugins = new ArrayList<JdbiPlugin>();
    private final ReentrantLock lock = new ReentrantLock();
    private volatile DataSource dataSource;
    private Jdbi jdbi;
    private Handle handle;
    private boolean installPlugins;
    private Migration migration;

    protected abstract DataSource createDataSource();

    private DataSource getDataSource() {
        if (this.dataSource == null) {
            try {
                this.lock.lock();
                if (this.dataSource == null) {
                    this.dataSource = this.createDataSource();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.dataSource;
    }

    public static JdbiRule embeddedPostgres() {
        return new EmbeddedPostgresJdbiRule();
    }

    public static JdbiRule externalPostgres(String hostname, Integer port, String username, String password, String database) {
        return new ExternalPostgresJdbiRule(hostname, port, username, password, database);
    }

    public static JdbiRule h2() {
        return new EmbeddedH2JdbiRule();
    }

    @Deprecated
    public JdbiRule migrateWithFlyway() {
        return this.migrateWithFlyway("db/migration");
    }

    @Deprecated
    public JdbiRule migrateWithFlyway(String ... locations) {
        return this.withMigration(Migration.before().withPaths(locations));
    }

    public JdbiRule withMigration(Migration migration) {
        this.migration = migration;
        return this;
    }

    public JdbiRule withPlugins() {
        this.installPlugins = true;
        return this;
    }

    public JdbiRule withPlugin(JdbiPlugin plugin) {
        this.plugins.add(plugin);
        return this;
    }

    protected void before() throws Throwable {
        if (this.migration != null) {
            Flyway flyway = new Flyway();
            flyway.setDataSource(this.getDataSource());
            flyway.setLocations(this.migration.paths.toArray(new String[0]));
            flyway.setSchemas(this.migration.schemas.toArray(new String[0]));
            flyway.migrate();
        }
        this.jdbi = Jdbi.create((DataSource)this.getDataSource());
        if (this.installPlugins) {
            this.jdbi.installPlugins();
        }
        this.plugins.forEach(arg_0 -> ((Jdbi)this.jdbi).installPlugin(arg_0));
        this.handle = this.jdbi.open();
    }

    protected void after() {
        if (this.migration != null && this.migration.cleanAfter) {
            Flyway flyway = new Flyway();
            flyway.setDataSource(this.getDataSource());
            flyway.setLocations(this.migration.paths.toArray(new String[0]));
            flyway.setSchemas(this.migration.schemas.toArray(new String[0]));
            flyway.clean();
        }
        this.handle.close();
        this.jdbi = null;
        this.dataSource = null;
    }

    public Jdbi getJdbi() {
        return this.jdbi;
    }

    public Handle getHandle() {
        return this.handle;
    }

    public <T> T attach(Class<T> extension) {
        return (T)this.getHandle().attach(extension);
    }
}

