/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing.junit5.internal;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.HandleListener;
import org.jdbi.v3.core.statement.Cleanable;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementContextListener;
import org.junit.jupiter.api.Assertions;

public final class JdbiLeakChecker
implements StatementContextListener,
HandleListener {
    private final ConcurrentMap<StatementContext, RecordingContext<Cleanable>> contextElements = new ConcurrentHashMap<StatementContext, RecordingContext<Cleanable>>();
    private final RecordingContext<Handle> handleTracker = new RecordingContext();

    public void contextCreated(StatementContext statementContext) {
        Objects.requireNonNull(statementContext, "statementContext is null!");
        Assertions.assertFalse((boolean)this.contextElements.containsKey(statementContext), () -> String.format("statement context %s has already been created by thread %s", statementContext, this.contextElements.get(statementContext)));
        this.contextElements.putIfAbsent(statementContext, new RecordingContext());
    }

    public void contextCleaned(StatementContext statementContext) {
        Objects.requireNonNull(statementContext, "statementContext is null!");
        Assertions.assertTrue((boolean)this.contextElements.containsKey(statementContext), () -> String.format("statement context %s is unknown", statementContext));
        RecordingContext context = (RecordingContext)this.contextElements.get(statementContext);
        Set leakedCleanables = context.leakedElements();
        if (!leakedCleanables.isEmpty()) {
            Assertions.fail((String)String.format("Found %d cleanables that were not removed [%s]", leakedCleanables.size(), leakedCleanables));
        }
        context.reset();
    }

    public void cleanableAdded(StatementContext statementContext, Cleanable cleanable) {
        Objects.requireNonNull(statementContext, "statementContext is null!");
        Objects.requireNonNull(cleanable, "cleanable is null");
        Assertions.assertTrue((boolean)this.contextElements.containsKey(statementContext), () -> String.format("statement context %s is unknown", statementContext));
        RecordingContext context = (RecordingContext)this.contextElements.get(statementContext);
        Assertions.assertFalse((boolean)context.objectAdded.containsKey(cleanable), () -> String.format("cleanable %s has already been added by thread %s", cleanable, context.objectAdded.get(cleanable)));
        Assertions.assertFalse((boolean)context.objectRemoved.containsKey(cleanable), () -> String.format("cleanable %s has already been removed by thread %s", cleanable, context.objectRemoved.get(cleanable)));
        context.objectAdded.putIfAbsent(cleanable, JdbiLeakChecker.getThreadName());
    }

    public void cleanableRemoved(StatementContext statementContext, Cleanable cleanable) {
        Objects.requireNonNull(statementContext, "statementContext is null!");
        Objects.requireNonNull(cleanable, "cleanable is null");
        Assertions.assertTrue((boolean)this.contextElements.containsKey(statementContext), () -> String.format("statement context %s is unknown", statementContext));
        RecordingContext context = (RecordingContext)this.contextElements.get(statementContext);
        Assertions.assertTrue((boolean)context.objectAdded.containsKey(cleanable), () -> String.format("cleanable %s is unknown", cleanable));
        Assertions.assertFalse((boolean)context.objectRemoved.containsKey(cleanable), () -> String.format("cleanable %s has already been removed by thread %s", cleanable, context.objectRemoved.get(cleanable)));
        context.objectRemoved.putIfAbsent(cleanable, JdbiLeakChecker.getThreadName());
    }

    public void handleCreated(Handle handle) {
        Objects.requireNonNull(handle, "handle is null");
        Assertions.assertFalse((boolean)this.handleTracker.objectAdded.containsKey(handle), () -> String.format("handle %s has already been added by thread %s", handle, this.handleTracker.objectAdded.get(handle)));
        Assertions.assertFalse((boolean)this.handleTracker.objectRemoved.containsKey(handle), () -> String.format("handle %s has already been removed by thread %s", handle, this.handleTracker.objectRemoved.get(handle)));
        this.handleTracker.objectAdded.putIfAbsent(handle, JdbiLeakChecker.getThreadName());
    }

    public void handleClosed(Handle handle) {
        Objects.requireNonNull(handle, "handle is null");
        Assertions.assertTrue((boolean)this.handleTracker.objectAdded.containsKey(handle), () -> String.format("handle %s is unknown", handle));
        Assertions.assertFalse((boolean)this.handleTracker.objectRemoved.containsKey(handle), () -> String.format("handle %s has already been removed by thread %s", handle, this.handleTracker.objectRemoved.get(handle)));
        this.handleTracker.objectRemoved.putIfAbsent(handle, JdbiLeakChecker.getThreadName());
    }

    public void checkForLeaks() {
        Set<Handle> leakedHandles = this.handleTracker.leakedElements();
        if (!leakedHandles.isEmpty()) {
            Assertions.fail((String)String.format("Found %d leaked handles.", leakedHandles.size()));
        }
        int leakedCleanablesCount = 0;
        for (RecordingContext context : this.contextElements.values()) {
            Set leakedCleanables = context.leakedElements();
            if (leakedCleanables.isEmpty()) continue;
            leakedCleanablesCount += leakedCleanables.size();
        }
        if (leakedCleanablesCount > 0) {
            Assertions.fail((String)String.format("Found %d leaked cleanable objects in %d contexts", leakedCleanablesCount, this.contextElements.size()));
        }
    }

    private static String getThreadName() {
        return Thread.currentThread().getName();
    }

    private static final class RecordingContext<T> {
        private final ConcurrentMap<T, String> objectAdded = new ConcurrentHashMap<T, String>();
        private final ConcurrentMap<T, String> objectRemoved = new ConcurrentHashMap<T, String>();

        private RecordingContext() {
        }

        public void reset() {
            this.objectAdded.clear();
            this.objectRemoved.clear();
        }

        public Set<T> leakedElements() {
            LinkedHashSet result = new LinkedHashSet();
            for (Object element : this.objectAdded.keySet()) {
                if (this.objectRemoved.containsKey(element)) continue;
                result.add(element);
            }
            return result;
        }

        public String toString() {
            return "Context " + Integer.toHexString(System.identityHashCode(this));
        }
    }
}

