/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing.junit5;

import de.softwareforge.testing.postgres.embedded.DatabaseInfo;
import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.SingleDatabaseBuilder;
import javax.sql.DataSource;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.extension.ExtensionContext;

public class JdbiPostgresExtension
extends JdbiExtension {
    private final EmbeddedPgExtension pg;
    private final boolean pgIsManaged;
    private volatile DatabaseInfo info;

    static JdbiExtension instance(EmbeddedPgExtension pg) {
        return new JdbiPostgresExtension(pg);
    }

    protected JdbiPostgresExtension(EmbeddedPgExtension pg) {
        this.pg = pg;
        this.pgIsManaged = false;
    }

    public JdbiPostgresExtension() {
        this.pg = (EmbeddedPgExtension)SingleDatabaseBuilder.instanceWithDefaults().build();
        this.pgIsManaged = true;
    }

    @Override
    public String getUrl() {
        return this.info.asJdbcUrl();
    }

    @Override
    protected DataSource createDataSource() throws Exception {
        return this.info.asDataSource();
    }

    @Override
    public void beforeEach(ExtensionContext context) throws Exception {
        try {
            if (this.pgIsManaged) {
                this.pg.beforeEach(context);
            }
        }
        finally {
            super.beforeEach(context);
        }
    }

    @Override
    public void beforeAll(ExtensionContext context) throws Exception {
        try {
            if (this.pgIsManaged) {
                this.pg.beforeAll(context);
            }
        }
        finally {
            super.beforeAll(context);
        }
    }

    @Override
    public void afterEach(ExtensionContext context) throws Exception {
        try {
            super.afterEach(context);
        }
        finally {
            if (this.pgIsManaged) {
                this.pg.afterEach(context);
            }
        }
    }

    @Override
    public void afterAll(ExtensionContext context) throws Exception {
        try {
            super.afterAll(context);
        }
        finally {
            if (this.pgIsManaged) {
                this.pg.afterAll(context);
            }
        }
    }

    @Override
    protected void startExtension() throws Exception {
        if (this.info != null) {
            throw new IllegalStateException("Extension was already started!");
        }
        this.info = this.pg.createDatabaseInfo();
        super.startExtension();
    }

    @Override
    protected void stopExtension() throws Exception {
        if (this.info == null) {
            throw new IllegalStateException("Extension was already stopped!");
        }
        try {
            super.stopExtension();
        }
        finally {
            this.info = null;
        }
    }
}

