/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing.junit5;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.jdbi.v3.testing.junit5.JdbiExtension;

public class JdbiGenericExtension
extends JdbiExtension {
    private final String jdbcUri;
    private String user = null;
    private String password = null;

    public JdbiGenericExtension(String jdbcUri) {
        this.jdbcUri = jdbcUri;
    }

    @Override
    public String getUrl() {
        return this.jdbcUri;
    }

    public JdbiGenericExtension withUser(String user) {
        this.user = user;
        return this;
    }

    public JdbiGenericExtension withCredentials(String user, String password) {
        this.user = user;
        this.password = password;
        return this;
    }

    @Override
    protected DataSource createDataSource() throws Exception {
        Driver driver = DriverManager.getDriver(this.jdbcUri);
        Properties info = new Properties();
        if (this.user != null) {
            info.put("user", this.user);
            if (this.password != null) {
                info.put("password", this.password);
            }
        }
        return new JdbiDataSource(driver, info);
    }

    final class JdbiDataSource
    implements DataSource {
        private final Driver driver;
        private final Properties rootProperties;

        JdbiDataSource(Driver driver, Properties rootProperties) {
            this.driver = driver;
            this.rootProperties = rootProperties;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.driver.connect(JdbiGenericExtension.this.jdbcUri, this.rootProperties);
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            Properties connectionProperties = new Properties(this.rootProperties);
            if (username != null) {
                connectionProperties.put("user", username);
                if (password != null) {
                    connectionProperties.put("password", password);
                }
            }
            return this.driver.connect(JdbiGenericExtension.this.jdbcUri, connectionProperties);
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            throw new UnsupportedOperationException("getLogWriter");
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new UnsupportedOperationException("setLogWriter");
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            throw new UnsupportedOperationException("setLoginTimeout");
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return 0;
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new UnsupportedOperationException("getParentLogger");
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new SQLException();
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }
    }
}

