/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing.junit5;

import java.util.UUID;
import javax.sql.DataSource;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.sqlite.SQLiteDataSource;

public class JdbiSqliteExtension
extends JdbiExtension {
    private static final String JDBC_URL_TEMPLATE = "jdbc:sqlite:file:%s?mode=memory&cache=shared";
    private final String url;

    static JdbiExtension instance() {
        return new JdbiSqliteExtension();
    }

    public JdbiSqliteExtension() {
        this(String.format(JDBC_URL_TEMPLATE, UUID.randomUUID().toString()));
    }

    public JdbiSqliteExtension(String url) {
        this.url = url;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    protected DataSource createDataSource() {
        SQLiteDataSource ds = new SQLiteDataSource();
        ds.setUrl(this.getUrl());
        return ds;
    }
}

