/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing.junit5;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import javax.sql.DataSource;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.postgresql.ds.PGSimpleDataSource;

public class JdbiExternalPostgresExtension
extends JdbiExtension {
    private final String hostname;
    private final Integer port;
    private final String username;
    private final String password;
    private final String database;
    private final String jdbcUri;

    protected JdbiExternalPostgresExtension(@NonNull String hostname, @Nullable Integer port, @NonNull String database, @Nullable String username, @Nullable String password) {
        this.hostname = Objects.requireNonNull(hostname, "hostname is null");
        this.port = port;
        this.database = Objects.requireNonNull(database, "database is null");
        this.username = username;
        this.password = password;
        StringBuilder sb = new StringBuilder("jdbc:postgresql://");
        sb.append(this.hostname);
        if (port != null) {
            sb.append(':').append(port);
        }
        sb.append("database");
        if (username != null) {
            sb.append("?user=").append(username);
        }
        this.jdbcUri = sb.toString();
    }

    static JdbiExtension instance(@NonNull String hostname, @Nullable Integer port, @NonNull String database, @Nullable String username, @Nullable String password) {
        return new JdbiExternalPostgresExtension(hostname, port, database, username, password);
    }

    @Override
    public String getUrl() {
        return this.jdbcUri;
    }

    @Override
    protected DataSource createDataSource() throws Exception {
        PGSimpleDataSource datasource = new PGSimpleDataSource();
        datasource.setServerNames(new String[]{this.hostname});
        if (this.port != null) {
            datasource.setPortNumbers(new int[]{this.port});
        }
        datasource.setUser(this.username);
        datasource.setPassword(this.password);
        datasource.setDatabaseName(this.database);
        datasource.setApplicationName(this.getClass().getSimpleName());
        return datasource;
    }
}

