/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing.junit5;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.testing.junit5.JdbiExtensionInitializer;
import org.jdbi.v3.testing.junit5.JdbiExternalPostgresExtension;
import org.jdbi.v3.testing.junit5.JdbiH2Extension;
import org.jdbi.v3.testing.junit5.JdbiOtjPostgresExtension;
import org.jdbi.v3.testing.junit5.JdbiPostgresExtension;
import org.jdbi.v3.testing.junit5.JdbiSqliteExtension;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;

public abstract class JdbiExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private final Set<JdbiPlugin> plugins = new LinkedHashSet<JdbiPlugin>();
    private Optional<JdbiExtensionInitializer> initializerMaybe = Optional.empty();
    private boolean installPlugins = false;
    private volatile Jdbi jdbi;
    private volatile Handle sharedHandle;
    private volatile boolean dataSourceInitialized = false;
    private volatile DataSource dataSource;

    public static JdbiExtension postgres(EmbeddedPgExtension pg) {
        return JdbiPostgresExtension.instance(pg);
    }

    public static JdbiExtension externalPostgres(@Nonnull String hostname, @Nullable Integer port, @Nonnull String database, @Nullable String username, @Nullable String password) {
        return JdbiExternalPostgresExtension.instance(hostname, port, database, username, password);
    }

    public static JdbiOtjPostgresExtension otjEmbeddedPostgres() {
        return JdbiOtjPostgresExtension.instance();
    }

    public static JdbiExtension h2() {
        return JdbiH2Extension.instance();
    }

    public static JdbiExtension sqlite() {
        return JdbiSqliteExtension.instance();
    }

    protected JdbiExtension() {
    }

    public final Jdbi getJdbi() {
        if (this.jdbi == null) {
            throw new IllegalStateException("jdbi is null!");
        }
        return this.jdbi;
    }

    public abstract String getUrl();

    public final Handle getSharedHandle() {
        if (this.sharedHandle == null) {
            throw new IllegalStateException("sharedHandle is null!");
        }
        return this.sharedHandle;
    }

    public final JdbiExtension installPlugins() {
        this.installPlugins = true;
        return this;
    }

    public final JdbiExtension withPlugin(JdbiPlugin plugin) {
        this.plugins.add(plugin);
        return this;
    }

    public final JdbiExtension withPlugins(JdbiPlugin ... pluginList) {
        this.plugins.addAll(Arrays.asList(pluginList));
        return this;
    }

    public final JdbiExtension withInitializer(JdbiExtensionInitializer initializer) {
        if (initializer == null) {
            throw new IllegalStateException("initializer is null!");
        }
        if (this.initializerMaybe.isPresent()) {
            throw new IllegalStateException("initializer already defined!");
        }
        this.initializerMaybe = Optional.of(initializer);
        return this;
    }

    public final Handle openHandle() {
        return this.getJdbi().open();
    }

    public final <C extends JdbiConfig<C>> JdbiExtension withConfig(Class<C> configClass, Consumer<C> configurer) {
        return this.withPlugin(ConfiguringPlugin.of(configClass, configurer));
    }

    public final <T> T attach(Class<T> extension) {
        return (T)this.getSharedHandle().attach(extension);
    }

    protected abstract DataSource createDataSource() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource getDataSource() throws Exception {
        if (!this.dataSourceInitialized) {
            JdbiExtension jdbiExtension = this;
            synchronized (jdbiExtension) {
                if (!this.dataSourceInitialized) {
                    DataSource ds;
                    this.dataSource = ds = this.createDataSource();
                    this.dataSourceInitialized = true;
                    return ds;
                }
            }
        }
        return this.dataSource;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (this.jdbi != null) {
            throw new IllegalStateException("jdbi has been set!");
        }
        DataSource ds = this.getDataSource();
        Jdbi jdbiInstance = Jdbi.create((DataSource)ds);
        if (this.installPlugins) {
            jdbiInstance.installPlugins();
        }
        this.plugins.forEach(arg_0 -> ((Jdbi)jdbiInstance).installPlugin(arg_0));
        Handle sharedHandleInstance = jdbiInstance.open();
        this.jdbi = jdbiInstance;
        this.sharedHandle = sharedHandleInstance;
        this.initializerMaybe.ifPresent(i -> i.initialize(ds, sharedHandleInstance));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterEach(ExtensionContext context) throws Exception {
        if (this.sharedHandle == null) {
            throw new IllegalStateException("shared handle was not initialized!");
        }
        try {
            DataSource ds = this.getDataSource();
            Handle handle = this.sharedHandle;
            this.initializerMaybe.ifPresent(i -> i.cleanup(ds, this.sharedHandle));
            handle.close();
        }
        finally {
            this.dataSourceInitialized = false;
            this.dataSource = null;
            this.sharedHandle = null;
            this.jdbi = null;
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> type = parameterContext.getParameter().getType();
        return type == Jdbi.class || type == Handle.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> type = parameterContext.getParameter().getType();
        if (type == Jdbi.class) {
            return this.getJdbi();
        }
        if (type == Handle.class) {
            return this.getSharedHandle();
        }
        return null;
    }

    private static final class ConfiguringPlugin<C extends JdbiConfig<C>>
    implements JdbiPlugin {
        private final Class<C> configClass;
        private final Consumer<C> configurer;

        private ConfiguringPlugin(Class<C> configClass, Consumer<C> configurer) {
            this.configClass = configClass;
            this.configurer = configurer;
        }

        static <C extends JdbiConfig<C>> ConfiguringPlugin<C> of(Class<C> configClass, Consumer<C> configurer) {
            return new ConfiguringPlugin<C>(configClass, configurer);
        }

        public void customizeJdbi(Jdbi jdbi) {
            jdbi.configure(this.configClass, this.configurer);
        }
    }
}

