/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing.junit5;

import de.softwareforge.testing.postgres.embedded.DatabaseInfo;
import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.SingleDatabaseBuilder;
import javax.sql.DataSource;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.extension.ExtensionContext;

public class JdbiPostgresExtension
extends JdbiExtension {
    private final EmbeddedPgExtension pg;
    private final boolean extendsWith;
    private volatile DatabaseInfo info;

    static final JdbiExtension instance(EmbeddedPgExtension pg) {
        return new JdbiPostgresExtension(pg);
    }

    protected JdbiPostgresExtension(EmbeddedPgExtension pg) {
        this.pg = pg;
        this.extendsWith = false;
    }

    public JdbiPostgresExtension() {
        this.pg = (EmbeddedPgExtension)SingleDatabaseBuilder.instanceWithDefaults().build();
        this.extendsWith = true;
    }

    @Override
    public String getUrl() {
        return this.info.asJdbcUrl();
    }

    @Override
    protected DataSource createDataSource() throws Exception {
        return this.info.asDataSource();
    }

    @Override
    public void beforeEach(ExtensionContext context) throws Exception {
        if (this.info != null) {
            throw new IllegalStateException("info has been set!");
        }
        if (this.extendsWith) {
            this.pg.beforeEach(context);
        }
        this.info = this.pg.createDatabaseInfo();
        super.beforeEach(context);
    }

    @Override
    public void afterEach(ExtensionContext context) throws Exception {
        if (this.info == null) {
            throw new IllegalStateException("info has been set!");
        }
        try {
            super.afterEach(context);
        }
        finally {
            this.info = null;
            if (this.extendsWith) {
                this.pg.afterEach(context);
            }
        }
    }
}

