/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing.junit5;

import com.opentable.db.postgres.embedded.EmbeddedPostgres;
import java.io.IOException;
import java.sql.Connection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.extension.ExtensionContext;

public class JdbiOtjPostgresExtension
extends JdbiExtension {
    private volatile EmbeddedPostgres epg;
    private volatile Connection postgresConnection;
    private final List<Consumer<EmbeddedPostgres.Builder>> builderCustomizers = new CopyOnWriteArrayList<Consumer<EmbeddedPostgres.Builder>>();

    static JdbiOtjPostgresExtension instance() {
        return new JdbiOtjPostgresExtension();
    }

    @Override
    public String getUrl() {
        EmbeddedPostgres pg = this.epg;
        if (pg == null) {
            throw new IllegalStateException("not within a Junit test!");
        }
        return pg.getJdbcUrl("postgres", "postgres");
    }

    @Override
    protected DataSource createDataSource() throws Exception {
        EmbeddedPostgres pg = this.epg;
        if (pg == null) {
            throw new IllegalStateException("not within a Junit test!");
        }
        return pg.getPostgresDatabase();
    }

    public JdbiOtjPostgresExtension customize(Consumer<EmbeddedPostgres.Builder> customizer) {
        this.builderCustomizers.add(customizer);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterEach(ExtensionContext context) throws Exception {
        super.afterEach(context);
        EmbeddedPostgres pg = this.epg;
        Connection c = this.postgresConnection;
        if (pg == null || c == null) {
            throw new IllegalStateException("not within a Junit test!");
        }
        try {
            this.postgresConnection = null;
            c.close();
        }
        finally {
            this.epg = null;
            pg.close();
        }
    }

    @Override
    public void beforeEach(ExtensionContext context) throws Exception {
        this.epg = this.createEmbeddedPostgres();
        this.postgresConnection = this.createDataSource().getConnection();
        super.beforeEach(context);
    }

    private EmbeddedPostgres createEmbeddedPostgres() throws IOException {
        EmbeddedPostgres.Builder builder = EmbeddedPostgres.builder();
        this.builderCustomizers.forEach(c -> c.accept(builder));
        return builder.start();
    }
}

