/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.testing.EmbeddedPostgresJdbiRule;
import org.junit.rules.ExternalResource;

public abstract class JdbiRule
extends ExternalResource {
    private Jdbi jdbi;
    private Handle handle;
    private boolean installPlugins;
    private List<JdbiPlugin> plugins = new ArrayList<JdbiPlugin>();

    protected abstract Jdbi createJdbi();

    public static JdbiRule embeddedPostgres() {
        return new EmbeddedPostgresJdbiRule();
    }

    public static JdbiRule h2() {
        return new JdbiRule(){

            @Override
            protected Jdbi createJdbi() {
                return Jdbi.create((String)("jdbc:h2:mem:" + UUID.randomUUID()));
            }
        };
    }

    public JdbiRule withPlugins() {
        this.installPlugins = true;
        return this;
    }

    public JdbiRule withPlugin(JdbiPlugin plugin) {
        this.plugins.add(plugin);
        return this;
    }

    protected void before() throws Throwable {
        this.jdbi = this.createJdbi();
        if (this.installPlugins) {
            this.jdbi.installPlugins();
        }
        this.plugins.forEach(arg_0 -> ((Jdbi)this.jdbi).installPlugin(arg_0));
        this.handle = this.jdbi.open();
    }

    protected void after() {
        this.handle.close();
        this.jdbi = null;
    }

    public Jdbi getJdbi() {
        return this.jdbi;
    }

    public Handle getHandle() {
        return this.handle;
    }

    public <T> T attach(Class<T> extension) {
        return (T)this.getHandle().attach(extension);
    }
}

