/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing.junit5.tc;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.jdbi.v3.meta.Alpha;
import org.jdbi.v3.meta.Beta;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.tc.TestcontainersDatabaseInformation;
import org.jdbi.v3.testing.junit5.tc.TestcontainersDatabaseInformationSupplier;
import org.testcontainers.containers.JdbcDatabaseContainer;

@Beta
public final class JdbiTestcontainersExtension
extends JdbiExtension {
    private final JdbcDatabaseContainer<?> jdbcDatabaseContainer;
    private final TestcontainersDatabaseInformation databaseInformation;
    private final TestcontainersDatabaseInformationSupplier instanceProvider;
    private volatile HikariDataSource masterDatasource = null;
    private volatile HikariConfig masterConfig = null;
    private volatile HikariDataSource schemaDatasource = null;

    public static JdbiTestcontainersExtension instance(JdbcDatabaseContainer<?> jdbcDatabaseContainer) {
        TestcontainersDatabaseInformation databaseInformation = TestcontainersDatabaseInformation.forTestcontainerClass(jdbcDatabaseContainer.getClass());
        if (databaseInformation == null) {
            throw new IllegalArgumentException(String.format("Container class '%s' is unknown!", jdbcDatabaseContainer.getClass().getName()));
        }
        return new JdbiTestcontainersExtension(databaseInformation, jdbcDatabaseContainer);
    }

    public static JdbiTestcontainersExtension instance(TestcontainersDatabaseInformation databaseInformation, JdbcDatabaseContainer<?> jdbcDatabaseContainer) {
        return new JdbiTestcontainersExtension(databaseInformation, jdbcDatabaseContainer);
    }

    private JdbiTestcontainersExtension(TestcontainersDatabaseInformation databaseInformation, JdbcDatabaseContainer<?> jdbcDatabaseContainer) {
        this.jdbcDatabaseContainer = jdbcDatabaseContainer;
        this.databaseInformation = databaseInformation;
        this.instanceProvider = new TestcontainersDatabaseInformationSupplier(databaseInformation);
    }

    @Alpha
    public JdbiTestcontainersExtension setShutdownWaitTimeInSeconds(int seconds) {
        this.databaseInformation.setShutdownWaitTimeInSeconds(seconds);
        return this;
    }

    public String getUrl() {
        return this.jdbcDatabaseContainer.getJdbcUrl();
    }

    protected DataSource createDataSource() {
        if (this.masterDatasource == null || this.masterConfig == null) {
            throw new IllegalArgumentException("Extension was not started!");
        }
        TestcontainersDatabaseInformation databaseInformation = this.instanceProvider.get();
        HikariConfig schemaConfig = new HikariConfig();
        this.masterConfig.copyStateTo(schemaConfig);
        databaseInformation.getCatalog().ifPresent(arg_0 -> ((HikariConfig)schemaConfig).setCatalog(arg_0));
        databaseInformation.getSchema().ifPresent(arg_0 -> ((HikariConfig)schemaConfig).setSchema(arg_0));
        schemaConfig.setPoolName(String.format("jdbi-test-pool (%s)", databaseInformation));
        try (HikariDataSource ds = this.schemaDatasource;){
            this.schemaDatasource = new HikariDataSource(schemaConfig);
        }
        return this.schemaDatasource;
    }

    protected void startExtension() throws Exception {
        if (this.masterDatasource != null || this.masterConfig != null) {
            throw new IllegalArgumentException("Extension was already started!");
        }
        this.masterConfig = new HikariConfig();
        this.masterConfig.setJdbcUrl(this.jdbcDatabaseContainer.getJdbcUrl());
        this.masterConfig.setUsername(this.databaseInformation.getUser().orElse(this.jdbcDatabaseContainer.getUsername()));
        this.masterConfig.setPassword(this.jdbcDatabaseContainer.getPassword());
        this.masterConfig.setDriverClassName(this.jdbcDatabaseContainer.getDriverClassName());
        this.masterConfig.setPoolName(String.format("jdbi-template-pool (%s)", this.databaseInformation));
        this.databaseInformation.getCatalog().ifPresent(arg_0 -> ((HikariConfig)this.masterConfig).setCatalog(arg_0));
        this.databaseInformation.getSchema().ifPresent(arg_0 -> ((HikariConfig)this.masterConfig).setSchema(arg_0));
        this.masterDatasource = new HikariDataSource(this.masterConfig);
        this.instanceProvider.start((DataSource)this.masterDatasource);
        super.startExtension();
    }

    protected void stopExtension() throws Exception {
        if (this.masterDatasource == null || this.masterConfig == null) {
            throw new IllegalArgumentException("Extension was not started!");
        }
        try (HikariDataSource masterDs = this.masterDatasource;
             HikariDataSource schemaDs = this.schemaDatasource;
             TestcontainersDatabaseInformationSupplier ip = this.instanceProvider;){
            super.stopExtension();
        }
    }
}

