/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing.junit5.tc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.jdbi.v3.testing.junit5.tc.EmbeddedUtil;
import org.jdbi.v3.testing.junit5.tc.TestcontainersDatabaseInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TestcontainersDatabaseInformationSupplier
implements Supplier<TestcontainersDatabaseInformation>,
AutoCloseable,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TestcontainersDatabaseInformationSupplier.class);
    private final TestcontainersDatabaseInformation templateDatabaseInformation;
    private final ExecutorService executor;
    private final SynchronousQueue<TestcontainersDatabaseInformation> nextSchema = new SynchronousQueue();
    private final AtomicBoolean closed = new AtomicBoolean();
    private volatile DataSource dataSource = null;

    TestcontainersDatabaseInformationSupplier(TestcontainersDatabaseInformation templateDatabaseInformation) {
        this.templateDatabaseInformation = templateDatabaseInformation;
        this.executor = Executors.newSingleThreadExecutor(runnable -> {
            Thread t = new Thread(runnable, "database-schema-creator");
            t.setDaemon(true);
            return t;
        });
    }

    void start(DataSource dataSource) {
        this.dataSource = dataSource;
        this.executor.submit(this);
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.executor.shutdownNow();
        }
    }

    @Override
    public void run() {
        while (!this.closed.get()) {
            try {
                String dbName = EmbeddedUtil.randomLowercase(12);
                String schemaName = EmbeddedUtil.randomLowercase(12);
                TestcontainersDatabaseInformation databaseInformation = this.templateDatabaseInformation.forCatalogAndSchema(this.templateDatabaseInformation.getCatalog().orElse(dbName), this.templateDatabaseInformation.getSchema().orElse(schemaName));
                this.executeStatements(databaseInformation.getCreationScript());
                this.nextSchema.put(databaseInformation);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (SQLException e) {
                LOG.error("SQL Exception caught:", (Throwable)e);
                break;
            }
            catch (Throwable t) {
                LOG.error("Could not create database:", t);
            }
        }
        this.closed.set(true);
    }

    /*
     * Exception decompiling
     */
    @Override
    public TestcontainersDatabaseInformation get() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void executeStatements(List<String> statements) throws SQLException {
        try (Connection c = this.dataSource.getConnection();){
            for (String statement : statements) {
                Statement stmt = c.createStatement();
                try {
                    stmt.executeUpdate(statement);
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                }
            }
        }
    }
}

