/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.stringtemplate4.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.SimpleExtensionConfigurer;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.internal.SqlAnnotations;
import org.jdbi.v3.sqlobject.locator.SqlLocator;
import org.jdbi.v3.stringtemplate4.StringTemplateSqlLocator;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

public class UseStringTemplateSqlLocatorImpl
extends SimpleExtensionConfigurer {
    private final SqlLocator locator;
    private final TemplateEngine templateEngine;

    public UseStringTemplateSqlLocatorImpl(Annotation annotation, Class<?> sqlObjectType) {
        STGroup group = StringTemplateSqlLocator.findStringTemplateGroup(sqlObjectType);
        this.locator = (type, method, config) -> {
            String templateName = SqlAnnotations.getAnnotationValue((Method)method).orElseGet(method::getName);
            if (!group.isDefined(templateName)) {
                throw new IllegalStateException(String.format("No StringTemplate group %s for class %s", templateName, sqlObjectType));
            }
            return templateName;
        };
        this.templateEngine = (templateName, ctx) -> {
            ST template = group.getInstanceOf(templateName);
            ctx.getAttributes().forEach((arg_0, arg_1) -> ((ST)template).add(arg_0, arg_1));
            return template.render();
        };
    }

    public void configure(ConfigRegistry config, Annotation annotation, Class<?> sqlObjectType) {
        ((SqlObjects)config.get(SqlObjects.class)).setSqlLocator(this.locator);
        ((SqlStatements)config.get(SqlStatements.class)).setTemplateEngine(this.templateEngine);
    }
}

