/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.stringtemplate4;

import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.jdbi.v3.stringtemplate4.StringTemplates;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.misc.STMessage;

public class StringTemplateEngine
implements TemplateEngine {
    public String render(String sql, StatementContext ctx) {
        STGroup group = new STGroup();
        group.setListener((STErrorListener)new ErrorListener(ctx));
        ST template = new ST(group, sql);
        ctx.getAttributes().forEach((arg_0, arg_1) -> ((ST)template).add(arg_0, arg_1));
        return template.render();
    }

    static class ErrorListener
    implements STErrorListener {
        private final StatementContext ctx;

        ErrorListener(StatementContext ctx) {
            this.ctx = ctx;
        }

        public void compileTimeError(STMessage msg) {
            throw new UnableToCreateStatementException("Compiling StringTemplate failed: " + msg, msg.cause, this.ctx);
        }

        public void runTimeError(STMessage msg) {
            switch (msg.error) {
                case NO_SUCH_PROPERTY: {
                    break;
                }
                case NO_SUCH_ATTRIBUTE: {
                    if (!((StringTemplates)this.ctx.getConfig(StringTemplates.class)).isFailOnMissingAttribute()) break;
                }
                default: {
                    throw new UnableToExecuteStatementException("Executing StringTemplate failed: " + msg, msg.cause, this.ctx);
                }
            }
        }

        public void IOError(STMessage msg) {
            this.runTimeError(msg);
        }

        public void internalError(STMessage msg) {
            this.runTimeError(msg);
        }
    }
}

