/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.stringtemplate4;

import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jdbi.v3.core.locator.internal.ClasspathBuilder;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;

public class StringTemplateSqlLocator {
    private static final Map<ClassLoader, Map<String, ThreadLocal<STGroup>>> CACHE = Collections.synchronizedMap(new WeakHashMap());

    private StringTemplateSqlLocator() {
    }

    public static ST findStringTemplate(Class<?> type, String name) {
        STGroup group = StringTemplateSqlLocator.findStringTemplateGroup(type);
        if (!group.isDefined(name)) {
            throw new IllegalStateException("No StringTemplate group " + name + " for class " + type);
        }
        return group.getInstanceOf(name);
    }

    public static ST findStringTemplate(String path, String name) {
        STGroup group = StringTemplateSqlLocator.findStringTemplateGroup(path);
        return StringTemplateSqlLocator.findTemplateInGroup(path, name, group);
    }

    public static ST findStringTemplate(ClassLoader classLoader, String path, String name) {
        STGroup group = StringTemplateSqlLocator.findStringTemplateGroup(classLoader, path);
        return StringTemplateSqlLocator.findTemplateInGroup(path, name, group);
    }

    private static ST findTemplateInGroup(String path, String name, STGroup group) {
        if (!group.isDefined(name)) {
            throw new IllegalStateException("No StringTemplate group " + name + " for path " + path);
        }
        return group.getInstanceOf(name);
    }

    public static STGroup findStringTemplateGroup(Class<?> type) {
        String path = new ClasspathBuilder().appendFullyQualifiedClassName(type).setExtension("sql.stg").build();
        return StringTemplateSqlLocator.findStringTemplateGroup(type.getClassLoader(), path);
    }

    public static STGroup findStringTemplateGroup(String path) {
        return StringTemplateSqlLocator.findStringTemplateGroup(Thread.currentThread().getContextClassLoader(), path);
    }

    public static STGroup findStringTemplateGroup(ClassLoader classLoader, String path) {
        return (STGroup)CACHE.computeIfAbsent(classLoader, x -> new ConcurrentHashMap()).computeIfAbsent(path, p -> ThreadLocal.withInitial(() -> StringTemplateSqlLocator.readStringTemplateGroup(classLoader, path))).get();
    }

    private static STGroup readStringTemplateGroup(ClassLoader classLoader, String path) {
        try {
            URL resource = classLoader.getResource(path);
            STGroupFile group = new STGroupFile(resource, StandardCharsets.UTF_8.name(), '<', '>');
            group.load();
            return group;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read StringTemplate group file at " + path + " on classpath", e);
        }
    }
}

