/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.stringtemplate4.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.SimpleExtensionConfigurer;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.internal.SqlAnnotations;
import org.jdbi.v3.sqlobject.locator.SqlLocator;
import org.jdbi.v3.stringtemplate4.StringTemplateSqlLocator;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

public class UseStringTemplateSqlLocatorImpl
extends SimpleExtensionConfigurer {
    public void configure(ConfigRegistry config, Annotation annotation, Class<?> sqlObjectType) {
        SqlLocator locator = (type, method, c) -> {
            String templateName = SqlAnnotations.getAnnotationValue((Method)method).orElseGet(method::getName);
            STGroup group = StringTemplateSqlLocator.findStringTemplateGroup(type);
            if (!group.isDefined(templateName)) {
                throw new IllegalStateException("No StringTemplate group " + templateName + " for class " + sqlObjectType);
            }
            return templateName;
        };
        TemplateEngine templateEngine = (templateName, ctx) -> {
            STGroup group = StringTemplateSqlLocator.findStringTemplateGroup(sqlObjectType);
            ST template = group.getInstanceOf(templateName);
            ctx.getAttributes().forEach((arg_0, arg_1) -> ((ST)template).add(arg_0, arg_1));
            return template.render();
        };
        ((SqlObjects)config.get(SqlObjects.class)).setSqlLocator(locator);
        ((SqlStatements)config.get(SqlStatements.class)).setTemplateEngine(templateEngine);
    }
}

