/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.stringtemplate4;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;

public class StringTemplateSqlLocator {
    private static final Map<String, ThreadLocal<STGroup>> CACHE = ExpiringMap.builder().expiration(10L, TimeUnit.MINUTES).expirationPolicy(ExpirationPolicy.ACCESSED).build();
    private static final String TEMPLATE_GROUP_EXTENSION = ".sql.stg";

    private StringTemplateSqlLocator() {
    }

    public static ST findStringTemplate(Class<?> type, String name) {
        STGroup group = StringTemplateSqlLocator.findStringTemplateGroup(type);
        if (!group.isDefined(name)) {
            throw new IllegalStateException("No StringTemplate group " + name + " for class " + type);
        }
        return group.getInstanceOf(name);
    }

    public static ST findStringTemplate(String path, String name) {
        STGroup group = StringTemplateSqlLocator.findStringTemplateGroup(path);
        return StringTemplateSqlLocator.findTemplateInGroup(path, name, group);
    }

    public static ST findStringTemplate(ClassLoader classLoader, String path, String name) {
        STGroup group = StringTemplateSqlLocator.findStringTemplateGroup(classLoader, path);
        return StringTemplateSqlLocator.findTemplateInGroup(path, name, group);
    }

    private static ST findTemplateInGroup(String path, String name, STGroup group) {
        if (!group.isDefined(name)) {
            throw new IllegalStateException("No StringTemplate group " + name + " for path " + path);
        }
        return group.getInstanceOf(name);
    }

    public static STGroup findStringTemplateGroup(Class<?> type) {
        return StringTemplateSqlLocator.findStringTemplateGroup(type.getClassLoader(), StringTemplateSqlLocator.resourcePathFor(type));
    }

    public static STGroup findStringTemplateGroup(String path) {
        return StringTemplateSqlLocator.findStringTemplateGroup(Thread.currentThread().getContextClassLoader(), path);
    }

    public static STGroup findStringTemplateGroup(ClassLoader classLoader, String path) {
        return (STGroup)CACHE.computeIfAbsent(path, p -> ThreadLocal.withInitial(() -> StringTemplateSqlLocator.readStringTemplateGroup(classLoader, path))).get();
    }

    private static STGroup readStringTemplateGroup(ClassLoader classLoader, String path) {
        try {
            URL resource = classLoader.getResource(path);
            STGroupFile group = new STGroupFile(resource, "UTF-8", '<', '>');
            group.load();
            return group;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read StringTemplate group file at " + path + " on classpath", e);
        }
    }

    private static String toString(InputStream inputStream) throws IOException {
        int rsz;
        char[] buffer = new char[1024];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        while ((rsz = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
            out.append(buffer, 0, rsz);
        }
        return out.toString();
    }

    private static InputStream openStream(ClassLoader classLoader, String path) {
        InputStream is = classLoader.getResourceAsStream(path);
        if (is == null) {
            throw new IllegalStateException("Unable to find StringTemplate group file at " + path + " on classpath");
        }
        return is;
    }

    private static String resourcePathFor(Class<?> clazz) {
        return clazz.getName().replace('.', '/') + TEMPLATE_GROUP_EXTENSION;
    }
}

