/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.stringtemplate4;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.rewriter.ColonPrefixStatementRewriter;
import org.jdbi.v3.core.rewriter.StatementRewriter;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.config.Configurer;
import org.jdbi.v3.sqlobject.config.ConfiguringAnnotation;
import org.jdbi.v3.sqlobject.internal.SqlAnnotations;
import org.jdbi.v3.sqlobject.locator.SqlLocator;
import org.jdbi.v3.stringtemplate4.StringTemplateSqlLocator;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

@ConfiguringAnnotation(value=Impl.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface UseStringTemplateSqlLocator {
    public Class<? extends StatementRewriter> value() default ColonPrefixStatementRewriter.class;

    public static class Impl
    implements Configurer {
        public void configureForType(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType) {
            UseStringTemplateSqlLocator useStringTemplateSqlLocator = (UseStringTemplateSqlLocator)annotation;
            SqlLocator locator = (type, method) -> {
                String templateName = SqlAnnotations.getAnnotationValue((Method)method).orElseGet(method::getName);
                STGroup group = StringTemplateSqlLocator.findStringTemplateGroup(type);
                if (!group.isDefined(templateName)) {
                    throw new IllegalStateException("No StringTemplate group " + templateName + " for class " + sqlObjectType);
                }
                return templateName;
            };
            StatementRewriter delegate = this.createDelegate(useStringTemplateSqlLocator.value());
            StatementRewriter locatingRewriter = (sql, params, ctx) -> {
                String templateName = sql;
                STGroup group = StringTemplateSqlLocator.findStringTemplateGroup(sqlObjectType);
                ST template = group.getInstanceOf(templateName);
                ctx.getAttributes().forEach((arg_0, arg_1) -> ((ST)template).add(arg_0, arg_1));
                String rewritten = template.render();
                return delegate.rewrite(rewritten, params, ctx);
            };
            ((SqlObjects)registry.get(SqlObjects.class)).setSqlLocator(locator);
            ((SqlStatements)registry.get(SqlStatements.class)).setStatementRewriter(locatingRewriter);
        }

        public void configureForMethod(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType, Method method) {
            this.configureForType(registry, annotation, sqlObjectType);
        }

        private StatementRewriter createDelegate(Class<? extends StatementRewriter> type) {
            try {
                return type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Error instantiating delegate statement rewriter: " + type, e);
            }
        }
    }
}

