/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.stringtemplate4;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.rewriter.ColonPrefixStatementRewriter;
import org.jdbi.v3.core.rewriter.StatementRewriter;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.sqlobject.config.Configurer;
import org.jdbi.v3.sqlobject.config.ConfiguringAnnotation;
import org.jdbi.v3.stringtemplate4.StringTemplateStatementRewriter;

@ConfiguringAnnotation(value=Impl.class)
@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface UseStringTemplateStatementRewriter {
    public Class<? extends StatementRewriter> value() default ColonPrefixStatementRewriter.class;

    public static class Impl
    implements Configurer {
        public void configureForType(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType) {
            UseStringTemplateStatementRewriter useStringTemplateStatementRewriter = (UseStringTemplateStatementRewriter)annotation;
            StatementRewriter delegate = this.createDelegate(useStringTemplateStatementRewriter.value());
            StringTemplateStatementRewriter rewriter = new StringTemplateStatementRewriter(delegate);
            ((SqlStatements)registry.get(SqlStatements.class)).setStatementRewriter((StatementRewriter)rewriter);
        }

        public void configureForMethod(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType, Method method) {
            this.configureForType(registry, annotation, sqlObjectType);
        }

        private StatementRewriter createDelegate(Class<? extends StatementRewriter> type) {
            try {
                return type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Error instantiating delegate statement rewriter: " + type, e);
            }
        }
    }
}

