/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.transaction.internal;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.stream.Stream;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.extension.AttachedExtensionHandler;
import org.jdbi.v3.core.extension.ExtensionHandler;
import org.jdbi.v3.core.extension.ExtensionHandlerCustomizer;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.transaction.TransactionException;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.sqlobject.transaction.Transaction;

public class TransactionDecorator
implements ExtensionHandlerCustomizer {
    public ExtensionHandler customize(ExtensionHandler delegate, Class<?> sqlObjectType, Method method) {
        Transaction txnAnnotation = Stream.of(method, sqlObjectType).map(ae -> ae.getAnnotation(Transaction.class)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new TransactionException("No @Transaction annotation found"));
        return (config, target) -> {
            AttachedExtensionHandler boundDelegate = delegate.attachTo(config, target);
            return new InTransaction(txnAnnotation, boundDelegate);
        };
    }

    static class InTransaction
    implements AttachedExtensionHandler {
        private final AttachedExtensionHandler boundDelegate;
        private final boolean readOnly;
        private final TransactionIsolationLevel isolation;

        InTransaction(Transaction txnAnnotation, AttachedExtensionHandler boundDelegate) {
            this.boundDelegate = boundDelegate;
            this.isolation = txnAnnotation.value();
            this.readOnly = txnAnnotation.readOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(final HandleSupplier handleSupplier, final Object ... args) throws Exception {
            Object object;
            block5: {
                boolean flipReadOnly;
                Handle handle = handleSupplier.getHandle();
                if (handle.isInTransaction() && handle.isReadOnly() && !this.readOnly) {
                    throw new TransactionException("Tried to execute a nested @Transaction(readOnly=false) inside a readOnly transaction");
                }
                HandleCallback<Object, Exception> callback = new HandleCallback<Object, Exception>(){

                    public Object withHandle(Handle handle) throws Exception {
                        return boundDelegate.invoke(handleSupplier, args);
                    }
                };
                boolean bl = flipReadOnly = this.readOnly != handle.isReadOnly();
                if (flipReadOnly) {
                    handle.setReadOnly(this.readOnly);
                }
                try {
                    object = handle.inTransaction(this.isolation, (HandleCallback)callback);
                    if (!flipReadOnly) break block5;
                    handle.setReadOnly(!this.readOnly);
                }
                catch (Throwable throwable) {
                    if (flipReadOnly) {
                        handle.setReadOnly(!this.readOnly);
                    }
                    throw throwable;
                }
            }
            return object;
        }
    }
}

