/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.transaction;

import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.transaction.TransactionalCallback;
import org.jdbi.v3.sqlobject.transaction.TransactionalConsumer;

public interface Transactional<This extends Transactional<This>>
extends SqlObject {
    default public void begin() {
        this.getHandle().begin();
    }

    default public void commit() {
        this.getHandle().commit();
    }

    default public void rollback() {
        this.getHandle().rollback();
    }

    default public boolean isInTransaction() {
        return this.getHandle().isInTransaction();
    }

    default public void savepoint(String savepointName) {
        this.getHandle().savepoint(savepointName);
    }

    default public void rollbackToSavepoint(String savepointName) {
        this.getHandle().rollbackToSavepoint(savepointName);
    }

    default public void releaseSavepoint(String savepointName) {
        this.getHandle().releaseSavepoint(savepointName);
    }

    default public <R, X extends Exception> R inTransaction(TransactionalCallback<R, This, X> callback) throws X {
        return this.withHandle(h -> h.inTransaction(txn -> callback.inTransaction(this)));
    }

    default public <R, X extends Exception> R inTransaction(TransactionIsolationLevel isolation, TransactionalCallback<R, This, X> callback) throws X {
        return this.withHandle(h -> h.inTransaction(isolation, txn -> callback.inTransaction(this)));
    }

    default public <X extends Exception> void useTransaction(TransactionalConsumer<This, X> callback) throws X {
        this.inTransaction(callback.asCallback());
    }

    default public <X extends Exception> void useTransaction(TransactionIsolationLevel isolation, TransactionalConsumer<This, X> callback) throws X {
        this.inTransaction(isolation, callback.asCallback());
    }
}

