/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.statement.Call;
import org.jdbi.v3.core.statement.OutParameters;
import org.jdbi.v3.sqlobject.statement.internal.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration;

public class SqlCallHandler
extends CustomizingStatementHandler<Call> {
    private final BiFunction<OutParameters, Call, ?> resultTransformer;

    public SqlCallHandler(Class<?> sqlObjectType, Method method) {
        super(sqlObjectType, method);
        this.resultTransformer = this.createResultTransformer(sqlObjectType, method);
    }

    private BiFunction<OutParameters, Call, ?> createResultTransformer(Class<?> sqlObjectType, Method method) {
        Type returnType = GenericTypes.resolveType((Type)method.getGenericReturnType(), sqlObjectType);
        Class returnClass = GenericTypes.getErasedType((Type)returnType);
        for (int idx = 0; idx < method.getParameterCount(); ++idx) {
            int pIdx = idx;
            Parameter p = method.getParameters()[idx];
            if (p.getType().equals(Function.class)) {
                return (outParameters, call) -> ((Function)((SqlObjectStatementConfiguration)call.getConfig(SqlObjectStatementConfiguration.class)).getArgs()[pIdx]).apply(outParameters);
            }
            if (!p.getType().equals(Consumer.class)) continue;
            return (outParameters, call) -> {
                ((Consumer)((SqlObjectStatementConfiguration)call.getConfig(SqlObjectStatementConfiguration.class)).getArgs()[pIdx]).accept(outParameters);
                return null;
            };
        }
        if (Void.TYPE.equals(returnClass)) {
            return (outParameters, call) -> null;
        }
        if (OutParameters.class.isAssignableFrom(returnClass)) {
            return (outParameters, call) -> outParameters;
        }
        throw new IllegalArgumentException("@SqlCall methods may only return null or OutParameters at present");
    }

    @Override
    Call createStatement(Handle handle, String locatedSql) {
        return handle.createCall(locatedSql);
    }

    @Override
    void configureReturner(Call call, SqlObjectStatementConfiguration cfg) {
        cfg.setReturner(() -> this.resultTransformer.apply(call.invoke(), call));
    }
}

