/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement.internal;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jdbi.v3.core.collector.JdbiCollectors;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.Mappers;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.qualifier.Qualifiers;
import org.jdbi.v3.core.result.ResultIterable;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.SingleValue;
import org.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration;

abstract class ResultReturner {
    ResultReturner() {
    }

    static ResultReturner forOptionalReturn(Class<?> extensionType, Method method) {
        if (method.getReturnType() == Void.TYPE) {
            return new VoidReturner();
        }
        return ResultReturner.forMethod(extensionType, method);
    }

    static ResultReturner forMethod(Class<?> extensionType, Method method) {
        Type returnType = GenericTypes.resolveType((Type)method.getGenericReturnType(), extensionType);
        QualifiedType qualifiedReturnType = QualifiedType.of((Type)returnType).withAnnotations((Iterable)new Qualifiers().findFor(new AnnotatedElement[]{method}));
        Class returnClass = GenericTypes.getErasedType((Type)returnType);
        if (Void.TYPE.equals(returnClass)) {
            return ResultReturner.findConsumer(method).orElseThrow(() -> new IllegalStateException(String.format("Method %s#%s is annotated as if it should return a value, but the method is void.", method.getDeclaringClass().getName(), method.getName())));
        }
        if (ResultIterable.class.equals((Object)returnClass)) {
            return new ResultIterableReturner(qualifiedReturnType);
        }
        if (Stream.class.equals((Object)returnClass)) {
            return new StreamReturner(qualifiedReturnType);
        }
        if (ResultIterator.class.equals((Object)returnClass)) {
            return new ResultIteratorReturner(qualifiedReturnType);
        }
        if (Iterator.class.equals((Object)returnClass)) {
            return new IteratorReturner(qualifiedReturnType);
        }
        if (method.isAnnotationPresent(SingleValue.class)) {
            return new SingleValueReturner(qualifiedReturnType);
        }
        return new CollectedResultReturner(qualifiedReturnType);
    }

    static Optional<ResultReturner> findConsumer(Method method) {
        Optional<ResultReturner> result = Optional.empty();
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            if (paramTypes[i] != Consumer.class) continue;
            if (result.isPresent()) {
                throw new IllegalArgumentException(String.format("Method %s has multiple consumer arguments!", method));
            }
            result = Optional.of(ConsumerResultReturner.of(method, i));
        }
        return result;
    }

    protected abstract Object mappedResult(ResultIterable<?> var1, StatementContext var2);

    protected abstract Object reducedResult(Stream<?> var1, StatementContext var2);

    protected abstract QualifiedType<?> elementType(ConfigRegistry var1);

    protected void warm(ConfigRegistry config) {
        Optional.ofNullable(this.elementType(config)).ifPresent(arg_0 -> ((Mappers)((Mappers)config.get(Mappers.class))).findFor(arg_0));
    }

    private static Object checkResult(Object result, QualifiedType<?> type) {
        if (result == null && GenericTypes.getErasedType((Type)type.getType()).isPrimitive()) {
            throw new IllegalStateException("SQL method returns primitive " + type + ", but statement returned no results");
        }
        return result;
    }

    static class VoidReturner
    extends ResultReturner {
        VoidReturner() {
        }

        @Override
        protected Void mappedResult(ResultIterable<?> iterable, StatementContext ctx) {
            iterable.stream().forEach(i -> {});
            return null;
        }

        @Override
        protected Void reducedResult(Stream<?> stream, StatementContext ctx) {
            throw new UnsupportedOperationException("Cannot return void from a @UseRowReducer method");
        }

        @Override
        protected QualifiedType<?> elementType(ConfigRegistry config) {
            return null;
        }
    }

    static class ResultIterableReturner
    extends ResultReturner {
        private final QualifiedType<?> elementType;

        ResultIterableReturner(QualifiedType<?> returnType) {
            this.elementType = (QualifiedType)returnType.flatMapType(type -> GenericTypes.findGenericParameter((Type)type, ResultIterable.class)).orElseThrow(() -> new IllegalStateException("Cannot reflect ResultIterable<T> element type T in method return type " + returnType));
        }

        protected ResultIterable<?> mappedResult(ResultIterable<?> iterable, StatementContext ctx) {
            return iterable;
        }

        protected ResultIterator<?> reducedResult(Stream<?> stream, StatementContext ctx) {
            throw new UnsupportedOperationException("Cannot return ResultIterable from a @UseRowReducer method");
        }

        @Override
        protected QualifiedType<?> elementType(ConfigRegistry config) {
            return this.elementType;
        }
    }

    static class StreamReturner
    extends ResultReturner {
        private final QualifiedType<?> elementType;

        StreamReturner(QualifiedType<?> returnType) {
            this.elementType = (QualifiedType)returnType.flatMapType(type -> GenericTypes.findGenericParameter((Type)type, Stream.class)).orElseThrow(() -> new IllegalStateException("Cannot reflect Stream<T> element type T in method return type " + returnType));
        }

        @Override
        protected Stream<?> mappedResult(ResultIterable<?> iterable, StatementContext ctx) {
            return iterable.stream();
        }

        @Override
        protected Stream<?> reducedResult(Stream<?> stream, StatementContext ctx) {
            return stream;
        }

        @Override
        protected QualifiedType<?> elementType(ConfigRegistry config) {
            return this.elementType;
        }
    }

    static class ResultIteratorReturner
    extends ResultReturner {
        private final QualifiedType<?> elementType;

        ResultIteratorReturner(QualifiedType<?> returnType) {
            this.elementType = (QualifiedType)returnType.flatMapType(type -> GenericTypes.findGenericParameter((Type)type, Iterator.class)).orElseThrow(() -> new IllegalStateException("Cannot reflect ResultIterator<T> element type T in method return type " + returnType));
        }

        protected ResultIterator<?> mappedResult(ResultIterable<?> iterable, StatementContext ctx) {
            return iterable.iterator();
        }

        protected ResultIterator<?> reducedResult(Stream<?> stream, StatementContext ctx) {
            throw new UnsupportedOperationException("Cannot return ResultIterator from a @UseRowReducer method");
        }

        @Override
        protected QualifiedType<?> elementType(ConfigRegistry config) {
            return this.elementType;
        }
    }

    static class IteratorReturner
    extends ResultReturner {
        private final QualifiedType<?> elementType;

        IteratorReturner(QualifiedType<?> returnType) {
            this.elementType = (QualifiedType)returnType.flatMapType(type -> GenericTypes.findGenericParameter((Type)type, Iterator.class)).orElseThrow(() -> new IllegalStateException("Cannot reflect Iterator<T> element type T in method return type " + returnType));
        }

        @Override
        protected Iterator<?> mappedResult(ResultIterable<?> iterable, StatementContext ctx) {
            return iterable.iterator();
        }

        @Override
        protected Iterator<?> reducedResult(Stream<?> stream, StatementContext ctx) {
            return stream.iterator();
        }

        @Override
        protected QualifiedType<?> elementType(ConfigRegistry config) {
            return this.elementType;
        }
    }

    static class SingleValueReturner<T>
    extends ResultReturner {
        private final QualifiedType<T> returnType;

        SingleValueReturner(QualifiedType<T> returnType) {
            this.returnType = returnType;
        }

        @Override
        protected Object mappedResult(ResultIterable<?> iterable, StatementContext ctx) {
            return ResultReturner.checkResult(iterable.findFirst().orElse(null), this.returnType);
        }

        @Override
        protected Object reducedResult(Stream<?> stream, StatementContext ctx) {
            return ResultReturner.checkResult(stream.findFirst().orElse(null), this.returnType);
        }

        protected QualifiedType<T> elementType(ConfigRegistry config) {
            return this.returnType;
        }
    }

    static class CollectedResultReturner<T>
    extends ResultReturner {
        private final QualifiedType<T> returnType;

        CollectedResultReturner(QualifiedType<T> returnType) {
            this.returnType = returnType;
        }

        @Override
        protected Object mappedResult(ResultIterable<?> iterable, StatementContext ctx) {
            Collector collector = ctx.findCollectorFor(this.returnType.getType()).orElse(null);
            if (collector != null) {
                return iterable.collect(collector);
            }
            return ResultReturner.checkResult(iterable.findFirst().orElse(null), this.returnType);
        }

        @Override
        protected Object reducedResult(Stream<?> stream, StatementContext ctx) {
            Collector collector = ctx.findCollectorFor(this.returnType.getType()).orElse(null);
            if (collector != null) {
                return stream.collect(collector);
            }
            return ResultReturner.checkResult(stream.findFirst().orElse(null), this.returnType);
        }

        @Override
        protected void warm(ConfigRegistry config) {
            super.warm(config);
            ((JdbiCollectors)config.get(JdbiCollectors.class)).findFor(this.returnType.getType());
        }

        @Override
        protected QualifiedType<?> elementType(ConfigRegistry config) {
            return this.returnType.flatMapType(type -> ((JdbiCollectors)config.get(JdbiCollectors.class)).findElementTypeFor(type)).orElse(this.returnType);
        }
    }

    static abstract class ConsumerResultReturner
    extends ResultReturner {
        private final int consumerIndex;
        private final QualifiedType<?> elementType;

        ConsumerResultReturner(int consumerIndex, QualifiedType<?> elementType) {
            this.consumerIndex = consumerIndex;
            this.elementType = elementType;
        }

        static ConsumerResultReturner of(Method method, int consumerIndex) {
            Type parameterType = method.getGenericParameterTypes()[consumerIndex];
            QualifiedType elementType = QualifiedType.of((Type)((Type)GenericTypes.findGenericParameter((Type)parameterType, Consumer.class).orElseThrow(() -> new IllegalStateException("Cannot reflect Consumer<T> element type T in method consumer parameter " + parameterType)))).withAnnotations((Iterable)new Qualifiers().findFor(new AnnotatedElement[]{method.getParameters()[consumerIndex]}));
            Type type = elementType.getType();
            if (GenericTypes.isSuperType(Iterator.class, (Type)type)) {
                if (GenericTypes.getErasedType((Type)type) == Iterator.class) {
                    return new ConsumeIteratorResultReturner(consumerIndex, elementType.mapType(t -> (Type)GenericTypes.findGenericParameter((Type)t, Iterator.class).orElseThrow(() -> new IllegalStateException("Couldn't find Iterator type on " + elementType))));
                }
                throw new IllegalArgumentException(String.format("Consumer argument for %s can not use a subtype of Iterator (found %s)!", method, type));
            }
            if (GenericTypes.isSuperType(Stream.class, (Type)type)) {
                if (GenericTypes.getErasedType((Type)type) == Stream.class) {
                    return new ConsumeStreamResultReturner(consumerIndex, elementType.mapType(t -> (Type)GenericTypes.findGenericParameter((Type)t, Stream.class).orElseThrow(() -> new IllegalStateException("Couldn't find Stream type on " + elementType))));
                }
                throw new IllegalArgumentException(String.format("Consumer argument for %s can not use a subtype of Stream (found %s)!", method, type));
            }
            if (GenericTypes.isSuperType(Iterable.class, (Type)type)) {
                return new ConsumeIterableResultReturner(consumerIndex, elementType.mapType(t -> (Type)GenericTypes.findGenericParameter((Type)t, Iterable.class).orElseThrow(() -> new IllegalStateException("Couldn't find Iterable type on " + elementType))));
            }
            return new ConsumeEachResultReturner(consumerIndex, elementType);
        }

        @Override
        protected Void mappedResult(ResultIterable<?> iterable, StatementContext ctx) {
            try (Stream stream = iterable.stream();){
                this.accept(stream, this.findConsumer(ctx));
            }
            return null;
        }

        @Override
        protected Void reducedResult(Stream<?> stream, StatementContext ctx) {
            try {
                this.accept(stream, this.findConsumer(ctx));
            }
            finally {
                stream.close();
            }
            return null;
        }

        private Consumer<Object> findConsumer(StatementContext ctx) {
            return (Consumer)((SqlObjectStatementConfiguration)ctx.getConfig(SqlObjectStatementConfiguration.class)).getArgs()[this.consumerIndex];
        }

        protected abstract void accept(Stream<?> var1, Consumer var2);

        @Override
        protected QualifiedType<?> elementType(ConfigRegistry config) {
            return this.elementType;
        }
    }

    static class ConsumeIterableResultReturner
    extends ConsumerResultReturner {
        ConsumeIterableResultReturner(int consumerIndex, QualifiedType<?> elementType) {
            super(consumerIndex, elementType);
        }

        @Override
        protected void accept(Stream<?> stream, Consumer consumer) {
            consumer.accept(stream::iterator);
        }
    }

    static class ConsumeStreamResultReturner
    extends ConsumerResultReturner {
        ConsumeStreamResultReturner(int consumerIndex, QualifiedType<?> elementType) {
            super(consumerIndex, elementType);
        }

        @Override
        protected void accept(Stream<?> stream, Consumer consumer) {
            consumer.accept(stream);
        }
    }

    static class ConsumeIteratorResultReturner
    extends ConsumerResultReturner {
        ConsumeIteratorResultReturner(int consumerIndex, QualifiedType<?> elementType) {
            super(consumerIndex, elementType);
        }

        @Override
        protected void accept(Stream<?> stream, Consumer consumer) {
            consumer.accept(stream.iterator());
        }
    }

    static class ConsumeEachResultReturner
    extends ConsumerResultReturner {
        ConsumeEachResultReturner(int consumerIndex, QualifiedType<?> elementType) {
            super(consumerIndex, elementType);
        }

        @Override
        protected void accept(Stream<?> stream, Consumer consumer) {
            stream.forEach(consumer);
        }
    }
}

