/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement.internal;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.qualifier.Qualifiers;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.result.ResultIterable;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.sqlobject.UnableToCreateSqlObjectException;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.jdbi.v3.sqlobject.statement.UseRowReducer;
import org.jdbi.v3.sqlobject.statement.internal.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.statement.internal.ResultReturner;
import org.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration;

public class SqlUpdateHandler
extends CustomizingStatementHandler<Update> {
    private final Function<Update, Object> resultTransformer;
    private final ResultReturner resultReturner;

    public SqlUpdateHandler(Class<?> sqlObjectType, Method method) {
        super(sqlObjectType, method);
        if (method.isAnnotationPresent(UseRowReducer.class)) {
            throw new UnsupportedOperationException("Cannot declare @UseRowReducer on a @SqlUpdate method.");
        }
        GetGeneratedKeys getGeneratedKeys = method.getAnnotation(GetGeneratedKeys.class);
        QualifiedType returnType = QualifiedType.of((Type)GenericTypes.resolveType((Type)method.getGenericReturnType(), sqlObjectType)).withAnnotations((Iterable)new Qualifiers().findFor(new AnnotatedElement[]{method}));
        if (getGeneratedKeys != null) {
            this.resultReturner = ResultReturner.forMethod(sqlObjectType, method);
            String[] columnNames = getGeneratedKeys.value();
            this.resultTransformer = update -> {
                ResultBearing resultBearing = update.executeAndReturnGeneratedKeys(columnNames);
                UseRowMapper useRowMapper = method.getAnnotation(UseRowMapper.class);
                ResultIterable iterable = useRowMapper == null ? resultBearing.mapTo(returnType) : resultBearing.map(SqlUpdateHandler.rowMapperFor(useRowMapper));
                return this.resultReturner.mappedResult(iterable, update.getContext());
            };
        } else if (this.isNumeric(method.getReturnType())) {
            this.resultTransformer = Update::execute;
            this.resultReturner = null;
        } else if (this.isBoolean(method.getReturnType())) {
            this.resultTransformer = update -> update.execute() > 0;
            this.resultReturner = null;
        } else {
            throw new UnableToCreateSqlObjectException(this.invalidReturnTypeMessage(method, returnType));
        }
    }

    @Override
    public void warm(ConfigRegistry config) {
        super.warm(config);
        if (this.resultReturner != null) {
            this.resultReturner.warm(config);
        }
    }

    @Override
    Update createStatement(Handle handle, String locatedSql) {
        return handle.createUpdate(locatedSql);
    }

    @Override
    void configureReturner(Update u, SqlObjectStatementConfiguration cfg) {
        cfg.setReturner(() -> this.resultTransformer.apply(u));
    }

    private boolean isNumeric(Class<?> type) {
        return Number.class.isAssignableFrom(type) || type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Void.TYPE);
    }

    private boolean isBoolean(Class<?> type) {
        return type.equals(Boolean.TYPE) || type.equals(Boolean.class);
    }

    private String invalidReturnTypeMessage(Method method, QualifiedType<?> returnType) {
        return method.getDeclaringClass().getSimpleName() + "." + method.getName() + " method is annotated with @SqlUpdate so should return void, boolean, or Number but is returning: " + returnType;
    }
}

