/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;
import org.jdbi.v3.sqlobject.statement.internal.ResultReturner;
import org.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration;

public class MapToFactory
implements SqlStatementCustomizerFactory {
    @Override
    public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type type) {
        return (stmt, arg) -> {
            Type typeArg;
            if (arg instanceof GenericType) {
                typeArg = ((GenericType)arg).getType();
            } else {
                if (!(arg instanceof Type)) {
                    throw new UnsupportedOperationException("@MapTo must take a Type, got a " + arg.getClass().getName());
                }
                typeArg = (Type)arg;
            }
            ResultReturner returner = ResultReturner.forMethod(sqlObjectType, method);
            ((SqlObjectStatementConfiguration)stmt.getConfig(SqlObjectStatementConfiguration.class)).setReturner(() -> returner.mappedResult(((ResultBearing)stmt).mapTo(typeArg), stmt.getContext()));
        };
    }
}

