/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.result.ResultIterable;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.SingleValue;

abstract class ResultReturner {
    ResultReturner() {
    }

    static ResultReturner forOptionalReturn(Class<?> extensionType, Method method) {
        if (method.getReturnType() == Void.TYPE) {
            return new VoidReturner();
        }
        return ResultReturner.forMethod(extensionType, method);
    }

    static ResultReturner forMethod(Class<?> extensionType, Method method) {
        Type returnType = GenericTypes.resolveType((Type)method.getGenericReturnType(), extensionType);
        Class returnClass = GenericTypes.getErasedType((Type)returnType);
        if (Void.TYPE.equals(returnClass)) {
            throw new IllegalStateException(String.format("Method %s#%s is annotated as if it should return a value, but the method is void.", method.getDeclaringClass().getName(), method.getName()));
        }
        if (ResultIterable.class.isAssignableFrom(returnClass)) {
            return new ResultIterableResultReturner(returnType);
        }
        if (Stream.class.isAssignableFrom(returnClass)) {
            return new StreamReturner(returnType);
        }
        if (Iterator.class.isAssignableFrom(returnClass)) {
            return new IteratorResultReturner(returnType);
        }
        if (method.isAnnotationPresent(SingleValue.class)) {
            return new SingleValueResultReturner(returnType);
        }
        return new CollectedResultReturner(returnType);
    }

    protected abstract Object result(ResultIterable<?> var1, StatementContext var2);

    protected abstract Type elementType(StatementContext var1);

    private static Object checkResult(Object result, Type type) {
        if (result == null && GenericTypes.getErasedType((Type)type).isPrimitive()) {
            throw new IllegalStateException("SQL method returns primitive " + type + ", but statement returned no results");
        }
        return result;
    }

    static class IteratorResultReturner
    extends ResultReturner {
        private final Type elementType;

        IteratorResultReturner(Type returnType) {
            this.elementType = (Type)GenericTypes.findGenericParameter((Type)returnType, Iterator.class).orElseThrow(() -> new IllegalStateException("Cannot reflect Iterator<T> element type T in method return type " + returnType));
        }

        @Override
        protected Object result(ResultIterable<?> iterable, StatementContext ctx) {
            return iterable.iterator();
        }

        @Override
        protected Type elementType(StatementContext ctx) {
            return this.elementType;
        }
    }

    static class ResultIterableResultReturner
    extends ResultReturner {
        private final Type elementType;

        ResultIterableResultReturner(Type returnType) {
            this.elementType = (Type)GenericTypes.findGenericParameter((Type)returnType, ResultIterable.class).orElseThrow(() -> new IllegalStateException("Cannot reflect ResultIterable<T> element type T in method return type " + returnType));
        }

        @Override
        protected Object result(ResultIterable<?> iterable, StatementContext ctx) {
            return iterable;
        }

        @Override
        protected Type elementType(StatementContext ctx) {
            return this.elementType;
        }
    }

    static class SingleValueResultReturner
    extends ResultReturner {
        private final Type returnType;

        SingleValueResultReturner(Type returnType) {
            this.returnType = returnType;
        }

        @Override
        protected Object result(ResultIterable<?> iterable, StatementContext ctx) {
            return ResultReturner.checkResult(iterable.findFirst().orElse(null), this.returnType);
        }

        @Override
        protected Type elementType(StatementContext ctx) {
            return this.returnType;
        }
    }

    static class CollectedResultReturner
    extends ResultReturner {
        private final Type returnType;

        CollectedResultReturner(Type returnType) {
            this.returnType = returnType;
        }

        @Override
        protected Object result(ResultIterable<?> iterable, StatementContext ctx) {
            Collector collector = ctx.findCollectorFor(this.returnType).orElse(null);
            if (collector != null) {
                return iterable.collect(collector);
            }
            return ResultReturner.checkResult(iterable.findFirst().orElse(null), this.returnType);
        }

        @Override
        protected Type elementType(StatementContext ctx) {
            return ctx.findElementTypeFor(this.returnType).orElse(this.returnType);
        }
    }

    static class StreamReturner
    extends ResultReturner {
        private final Type elementType;

        StreamReturner(Type returnType) {
            this.elementType = (Type)GenericTypes.findGenericParameter((Type)returnType, Stream.class).orElseThrow(() -> new IllegalStateException("Cannot reflect Stream<T> element type T in method return type " + returnType));
        }

        @Override
        protected Stream<?> result(ResultIterable<?> iterable, StatementContext ctx) {
            return iterable.stream();
        }

        @Override
        protected Type elementType(StatementContext ctx) {
            return this.elementType;
        }
    }

    static class VoidReturner
    extends ResultReturner {
        VoidReturner() {
        }

        @Override
        protected Object result(ResultIterable<?> iterable, StatementContext ctx) {
            iterable.stream().forEach(i -> {});
            return null;
        }

        @Override
        protected Type elementType(StatementContext ctx) {
            return null;
        }
    }
}

