/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.result.ResultSetIterable;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerFactory;
import org.jdbi.v3.sqlobject.SqlMethodAnnotation;
import org.jdbi.v3.sqlobject.statement.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.statement.ResultReturner;
import org.jdbi.v3.sqlobject.statement.SqlObjectStatementConfiguration;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@SqlMethodAnnotation(value=Factory.class)
public @interface SqlQuery {
    public String value() default "";

    public static class QueryHandler
    extends CustomizingStatementHandler<Query> {
        private final ResultReturner magic;

        QueryHandler(Class<?> sqlObjectType, Method method) {
            super(sqlObjectType, method);
            this.magic = ResultReturner.forMethod(sqlObjectType, method);
        }

        @Override
        void configureReturner(Query q, SqlObjectStatementConfiguration cfg) {
            cfg.setReturner(() -> this.magic.map((ResultSetIterable)q, q.getContext()));
        }

        @Override
        Query createStatement(Handle handle, String locatedSql) {
            return handle.createQuery(locatedSql);
        }
    }

    public static class Factory
    implements HandlerFactory {
        @Override
        public Handler buildHandler(Class<?> sqlObjectType, Method method) {
            return new QueryHandler(sqlObjectType, method);
        }
    }
}

