/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizer;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.jdbi.v3.core.internal.ReflectionArrayIterator;

final class BindListUtil {
    private BindListUtil() {
    }

    static Iterator<?> toIterator(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("cannot make iterator of null");
        }
        if (obj instanceof Iterable) {
            return ((Iterable)obj).iterator();
        }
        if (obj.getClass().isArray()) {
            if (obj instanceof Object[]) {
                return Arrays.asList((Object[])obj).iterator();
            }
            return ReflectionArrayIterator.of((Object)obj);
        }
        throw new IllegalArgumentException(BindListUtil.getTypeWarning(obj.getClass()));
    }

    static boolean isEmpty(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("cannot determine emptiness of null");
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Iterable) {
            return !((Iterable)obj).iterator().hasNext();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        throw new IllegalArgumentException(BindListUtil.getTypeWarning(obj.getClass()));
    }

    private static String getTypeWarning(Class<?> type) {
        return "argument must be one of the following: Iterable, or an array/varargs (primitive or complex type); was " + type.getName() + " instead";
    }
}

