/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.argument.ObjectArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.sqlobject.config.ConfigurerFactory;
import org.jdbi.v3.sqlobject.config.ConfiguringAnnotation;

@ConfiguringAnnotation(value=Factory.class)
@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface RegisterObjectArgumentFactory {
    public Class<?>[] value();

    public int[] sqlType() default {};

    public static class Factory
    implements ConfigurerFactory {
        @Override
        public Consumer<ConfigRegistry> createForType(Annotation annotation, Class<?> sqlObjectType) {
            return this.create((RegisterObjectArgumentFactory)annotation);
        }

        @Override
        public Consumer<ConfigRegistry> createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            return this.create((RegisterObjectArgumentFactory)annotation);
        }

        private Consumer<ConfigRegistry> create(RegisterObjectArgumentFactory annotation) {
            Class<?>[] classes = annotation.value();
            int[] sqlTypes = annotation.sqlType();
            if (sqlTypes.length != 0 && sqlTypes.length != classes.length) {
                throw new IllegalStateException("RegisterObjectArgumentFactory.sqlTypes() must have the same number of elements as value()");
            }
            ArrayList<ArgumentFactory> factories = new ArrayList<ArgumentFactory>(classes.length);
            for (int i = 0; i < classes.length; ++i) {
                Class<?> clazz = classes[i];
                Integer sqlType = sqlTypes.length == 0 ? null : Integer.valueOf(sqlTypes[i]);
                factories.add(ObjectArgumentFactory.create(clazz, (Integer)sqlType));
            }
            return config -> factories.forEach(arg_0 -> ((Arguments)((Arguments)config.get(Arguments.class))).register(arg_0));
        }
    }
}

