/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.sql.SQLException;
import org.jdbi.v3.core.Call;
import org.jdbi.v3.core.SqlStatement;
import org.jdbi.v3.sqlobject.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizingAnnotation;

@SqlStatementCustomizingAnnotation(value=Factory.class)
@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface OutParameter {
    public String name();

    public int sqlType();

    public static class Factory
    implements SqlStatementCustomizerFactory {
        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            throw new UnsupportedOperationException("Not allowed on Type");
        }

        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            final OutParameter outParam = (OutParameter)annotation;
            return new SqlStatementCustomizer(){

                public void apply(SqlStatement q) throws SQLException {
                    ((Call)q).registerOutParameter(outParam.name(), outParam.sqlType());
                }
            };
        }

        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Parameter param, Object arg) {
            throw new UnsupportedOperationException("Not defined for parameter");
        }
    }
}

