/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jdbi.v3.core.SqlStatement;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.ObjectArgumentFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizingAnnotation;

@SqlStatementCustomizingAnnotation(value=Factory.class)
@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface RegisterObjectArgumentFactory {
    public Class<?>[] value();

    public int[] sqlType() default {};

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class<?> sqlObjectType) {
            return this.create((RegisterObjectArgumentFactory)annotation);
        }

        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            return this.create((RegisterObjectArgumentFactory)annotation);
        }

        private SqlStatementCustomizer create(RegisterObjectArgumentFactory annotation) {
            Class<?>[] classes = annotation.value();
            int[] sqlTypes = annotation.sqlType();
            if (sqlTypes.length != 0 && sqlTypes.length != classes.length) {
                throw new IllegalStateException("RegisterObjectArgumentFactory.sqlTypes() must have the same number of elements as value()");
            }
            ArrayList<ArgumentFactory> factories = new ArrayList<ArgumentFactory>(classes.length);
            for (int i = 0; i < classes.length; ++i) {
                Class<?> clazz = classes[i];
                Integer sqlType = sqlTypes.length == 0 ? null : Integer.valueOf(sqlTypes[i]);
                factories.add(ObjectArgumentFactory.create(clazz, (Integer)sqlType));
            }
            return q -> factories.forEach(arg_0 -> ((SqlStatement)q).registerArgumentFactory(arg_0));
        }
    }
}

