/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jdbi.v3.core.SqlStatement;
import org.jdbi.v3.core.mapper.ConstructorMapper;
import org.jdbi.v3.sqlobject.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizingAnnotation;

@SqlStatementCustomizingAnnotation(value=Factory.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface RegisterConstructorMapper {
    public Class<?>[] value();

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            return this.create((RegisterConstructorMapper)annotation);
        }

        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class<?> sqlObjectType) {
            return this.create((RegisterConstructorMapper)annotation);
        }

        private SqlStatementCustomizer create(RegisterConstructorMapper rcm) {
            List mappers = Arrays.stream(rcm.value()).map(ConstructorMapper::factoryFor).collect(Collectors.toList());
            return stmt -> mappers.forEach(arg_0 -> ((SqlStatement)stmt).registerRowMapper(arg_0));
        }
    }
}

