/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.jdbi.v3.core.collector.CollectorFactory;
import org.jdbi.v3.core.collector.JdbiCollectors;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.sqlobject.config.Configurer;
import org.jdbi.v3.sqlobject.config.ConfiguringAnnotation;

@ConfiguringAnnotation(value=Impl.class)
@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface RegisterCollectorFactory {
    public Class<? extends CollectorFactory>[] value();

    public static class Impl
    implements Configurer {
        @Override
        public void configureForMethod(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType, Method method) {
            this.configureForType(registry, annotation, sqlObjectType);
        }

        @Override
        public void configureForType(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType) {
            RegisterCollectorFactory registerCollectorFactory = (RegisterCollectorFactory)annotation;
            JdbiCollectors collectors = (JdbiCollectors)registry.get(JdbiCollectors.class);
            for (Class<? extends CollectorFactory> type : registerCollectorFactory.value()) {
                try {
                    collectors.register(type.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalStateException("Unable to instantiate container factory", e);
                }
            }
        }
    }
}

