/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import java.util.function.Supplier;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Query;
import org.jdbi.v3.core.SqlStatement;
import org.jdbi.v3.sqlobject.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.ResultReturnThing;
import org.jdbi.v3.sqlobject.SqlObjectConfig;

class QueryHandler
extends CustomizingStatementHandler {
    private final Class<?> sqlObjectType;
    private final ResultReturnThing magic;

    QueryHandler(Class<?> sqlObjectType, Method method, ResultReturnThing magic) {
        super(sqlObjectType, method);
        this.sqlObjectType = sqlObjectType;
        this.magic = magic;
    }

    @Override
    public Object invoke(Supplier<Handle> handle, SqlObjectConfig config, Object target, Object[] args, Method method) {
        String sql = config.getSqlLocator().locate(this.sqlObjectType, method);
        Query q = handle.get().createQuery(sql);
        this.applyCustomizers((SqlStatement<?>)q, args);
        this.applyBinders((SqlStatement<?>)q, args);
        return this.magic.map(method, q, handle);
    }
}

