/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.jdbi.v3.sqlobject.BindMap;
import org.jdbi.v3.sqlobject.Binder;
import org.jdbi.v3.sqlobject.BinderFactory;

class BindMapFactory
implements BinderFactory<BindMap, Map<String, Object>> {
    BindMapFactory() {
    }

    @Override
    public Binder<BindMap, Map<String, Object>> build(BindMap annotation) {
        return (q, param, index, bind, arg) -> {
            String prefix = "___jdbi_bare___".equals(bind.prefix()) ? "" : bind.prefix() + ".";
            HashSet<String> allowedKeys = new HashSet<String>(Arrays.asList(bind.value()));
            for (Map.Entry e : arg.entrySet()) {
                Object keyObj = e.getKey();
                if (!bind.implicitKeyStringConversion() && !(keyObj instanceof String)) {
                    throw new IllegalArgumentException("Key " + keyObj + " (of " + keyObj.getClass() + ") must be a String");
                }
                String key = keyObj.toString();
                if (!allowedKeys.isEmpty() && !allowedKeys.remove(key)) continue;
                q.bind(prefix + key, e.getValue());
            }
            for (String key : allowedKeys) {
                Object val = arg.get(key);
                if (val != null) {
                    throw new IllegalStateException("Internal error: map iteration missed key " + key);
                }
                q.bind(prefix + key, null);
            }
        };
    }
}

