/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.stringtemplate;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jdbi.v3.StatementContext;
import org.jdbi.v3.statement.StatementLocator;

public class StringTemplate3StatementLocator
implements StatementLocator {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final ConcurrentMap<String, StringTemplateGroup> ANNOTATION_LOCATOR_CACHE;
    private static final String SUPER_SEPARATOR = " > ";
    public static final String TEMPLATE_GROUP_EXTENSION = ".sql.stg";
    private final StringTemplateGroup literals = new StringTemplateGroup("literals");
    private final StringTemplateGroup group;
    private final boolean treatLiteralsAsTemplates;
    private static final String sep = "/";

    public static Builder builder(Class<?> baseClass) {
        return new Builder(baseClass);
    }

    public static Builder builder(String path) {
        return new Builder(path);
    }

    private StringTemplate3StatementLocator(String templateGroupFilePathOnClasspath, String superTemplateGroupFilePathOnClasspath, StringTemplateErrorListener errorListener, boolean allowImplicitTemplateGroup, boolean treatLiteralsAsTemplates, boolean shouldCache) {
        StringTemplateGroup superGroup;
        this.treatLiteralsAsTemplates = treatLiteralsAsTemplates;
        StringBuilder sb = new StringBuilder(templateGroupFilePathOnClasspath);
        if (superTemplateGroupFilePathOnClasspath != null) {
            sb.append(SUPER_SEPARATOR).append(superTemplateGroupFilePathOnClasspath);
            superGroup = StringTemplate3StatementLocator.createGroup(superTemplateGroupFilePathOnClasspath, errorListener, shouldCache ? superTemplateGroupFilePathOnClasspath : null, allowImplicitTemplateGroup, this.getClass(), null);
        } else {
            superGroup = null;
        }
        this.group = StringTemplate3StatementLocator.createGroup(templateGroupFilePathOnClasspath, errorListener, shouldCache ? sb.toString() : null, allowImplicitTemplateGroup, this.getClass(), superGroup);
        if (this.literals != null) {
            this.literals.setErrorListener(errorListener);
        }
        this.group.setErrorListener(errorListener);
    }

    private static StringTemplateGroup createGroup(String templateGroupFilePathOnClasspath, StringTemplateErrorListener errorListener, String cacheKey, boolean allowImplicitTemplateGroup, Class<?> clazz, StringTemplateGroup superGroup) {
        StringTemplateGroup oldGroup;
        if (cacheKey != null && ANNOTATION_LOCATOR_CACHE.containsKey(cacheKey)) {
            return (StringTemplateGroup)ANNOTATION_LOCATOR_CACHE.get(cacheKey);
        }
        InputStream ins = clazz.getResourceAsStream(templateGroupFilePathOnClasspath);
        if (allowImplicitTemplateGroup && ins == null) {
            return (StringTemplateGroup)ANNOTATION_LOCATOR_CACHE.get("empty template group");
        }
        if (ins == null) {
            throw new IllegalStateException("unable to find group file " + templateGroupFilePathOnClasspath + " on classpath");
        }
        InputStreamReader reader = new InputStreamReader(ins, UTF_8);
        StringTemplateGroup result = superGroup == null ? new StringTemplateGroup((Reader)reader, errorListener) : new StringTemplateGroup((Reader)reader, null, errorListener, superGroup);
        if (cacheKey != null && (oldGroup = ANNOTATION_LOCATOR_CACHE.putIfAbsent(cacheKey, result)) != null) {
            result = oldGroup;
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to load string template group " + templateGroupFilePathOnClasspath, e);
        }
        return result;
    }

    public String locate(String name, StatementContext ctx) throws Exception {
        if (this.group.isDefined(name)) {
            StringTemplate t = this.group.getInstanceOf(name);
            t.reset();
            for (Map.Entry entry : ctx.getAttributes().entrySet()) {
                t.setAttribute((String)entry.getKey(), entry.getValue());
            }
            return t.toString();
        }
        if (this.treatLiteralsAsTemplates) {
            String key = Base64.getEncoder().encodeToString(name.getBytes(UTF_8));
            if (!this.literals.isDefined(key)) {
                this.literals.defineTemplate(key, name);
            }
            StringTemplate t = this.literals.getInstanceOf(key);
            for (Map.Entry entry : ctx.getAttributes().entrySet()) {
                t.setAttribute((String)entry.getKey(), entry.getValue());
            }
            return t.toString();
        }
        return name;
    }

    private static String mungify(Class<?> clazz) {
        return sep + clazz.getName().replaceAll("\\.", Matcher.quoteReplacement(sep)) + TEMPLATE_GROUP_EXTENSION;
    }

    static boolean templateCached(Class<?> clazzKey, Class<?> superKey) {
        StringBuilder sb = new StringBuilder(StringTemplate3StatementLocator.mungify(clazzKey));
        if (superKey != null) {
            sb.append(SUPER_SEPARATOR);
            sb.append(StringTemplate3StatementLocator.mungify(superKey));
        }
        return ANNOTATION_LOCATOR_CACHE.containsKey(sb.toString());
    }

    static {
        ConcurrentHashMap<String, StringTemplateGroup> cache = new ConcurrentHashMap<String, StringTemplateGroup>();
        cache.put("empty template group", new StringTemplateGroup("empty template group"));
        ANNOTATION_LOCATOR_CACHE = cache;
    }

    public static class Builder {
        private final String basePath;
        private String superGroupPath;
        private StringTemplateErrorListener errorListener = null;
        private boolean allowImplicitTemplateGroupEnabled = false;
        private boolean treatLiteralsAsTemplatesEnabled = false;
        private boolean shouldCacheEnabled = false;

        Builder(Class<?> baseClass) {
            this.basePath = StringTemplate3StatementLocator.mungify(baseClass);
        }

        Builder(String basePath) {
            this.basePath = basePath;
        }

        public Builder withSuperGroup(Class<?> superGroupClass) {
            this.superGroupPath = StringTemplate3StatementLocator.mungify(superGroupClass);
            return this;
        }

        public Builder withSuperGroup(String superGroupPath) {
            this.superGroupPath = superGroupPath;
            return this;
        }

        public Builder withErrorListener(StringTemplateErrorListener errorListener) {
            this.errorListener = errorListener;
            return this;
        }

        public Builder allowImplicitTemplateGroup() {
            this.allowImplicitTemplateGroupEnabled = true;
            return this;
        }

        public Builder treatLiteralsAsTemplates() {
            this.treatLiteralsAsTemplatesEnabled = true;
            return this;
        }

        public Builder shouldCache() {
            this.shouldCacheEnabled = true;
            return this;
        }

        public StringTemplate3StatementLocator build() {
            return new StringTemplate3StatementLocator(this.basePath, this.superGroupPath, this.errorListener, this.allowImplicitTemplateGroupEnabled, this.treatLiteralsAsTemplatesEnabled, this.shouldCacheEnabled);
        }
    }
}

