/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import org.jdbi.v3.GeneratedKeys;
import org.jdbi.v3.Handle;
import org.jdbi.v3.ResultBearing;
import org.jdbi.v3.SqlStatement;
import org.jdbi.v3.Update;
import org.jdbi.v3.exception.UnableToCreateStatementException;
import org.jdbi.v3.sqlobject.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.DefaultGeneratedKeyMapper;
import org.jdbi.v3.sqlobject.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.ResultReturnThing;
import org.jdbi.v3.sqlobject.SqlAnnotations;
import org.jdbi.v3.sqlobject.SqlUpdate;
import org.jdbi.v3.sqlobject.exceptions.UnableToCreateSqlObjectException;
import org.jdbi.v3.util.GenericTypes;

class UpdateHandler
extends CustomizingStatementHandler {
    private final String sql;
    private final Returner returner;

    UpdateHandler(Class<?> sqlObjectType, Method method) {
        super(sqlObjectType, method);
        boolean isGetGeneratedKeys = method.isAnnotationPresent(GetGeneratedKeys.class);
        Type returnType = GenericTypes.resolveType((Type)method.getGenericReturnType(), sqlObjectType);
        if (!isGetGeneratedKeys && this.returnTypeIsInvalid(method.getReturnType())) {
            throw new UnableToCreateSqlObjectException(this.invalidReturnTypeMessage(method, returnType));
        }
        this.sql = SqlAnnotations.getSql(method.getAnnotation(SqlUpdate.class), method);
        if (isGetGeneratedKeys) {
            DefaultGeneratedKeyMapper mapper;
            ResultReturnThing magic = ResultReturnThing.forMethod(sqlObjectType, method);
            GetGeneratedKeys ggk = method.getAnnotation(GetGeneratedKeys.class);
            if (DefaultGeneratedKeyMapper.class.equals(ggk.value())) {
                mapper = new DefaultGeneratedKeyMapper(returnType, ggk.columnName());
            } else {
                try {
                    mapper = ggk.value().newInstance();
                }
                catch (Exception e) {
                    throw new UnableToCreateStatementException("Unable to instantiate row mapper for statement", (Throwable)e, null);
                }
            }
            this.returner = (update, handle) -> {
                GeneratedKeys o = update.executeAndReturnGeneratedKeys(mapper, ggk.columnName());
                return magic.result((ResultBearing<?>)o, handle);
            };
        } else {
            this.returner = (update, handle) -> update.execute();
        }
    }

    @Override
    public Object invoke(Supplier<Handle> handle, Object target, Object[] args, Method method) {
        Update q = handle.get().createStatement(this.sql);
        this.populateSqlObjectData(q.getContext());
        this.applyCustomizers((SqlStatement<?>)q, args);
        this.applyBinders((SqlStatement<?>)q, args);
        return this.returner.value(q, handle);
    }

    private boolean returnTypeIsInvalid(Class<?> type) {
        return !Number.class.isAssignableFrom(type) && !type.equals(Integer.TYPE) && !type.equals(Long.TYPE) && !type.equals(Void.TYPE);
    }

    private String invalidReturnTypeMessage(Method method, Type returnType) {
        return method.getDeclaringClass().getSimpleName() + "." + method.getName() + " method is annotated with @SqlUpdate so should return void or Number but is returning: " + returnType;
    }

    private static interface Returner {
        public Object value(Update var1, Supplier<Handle> var2);
    }
}

