/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jdbi.v3.Handle;
import org.jdbi.v3.sqlobject.Handler;

class ToStringHandler
implements Handler {
    private final String className;

    ToStringHandler(String className) {
        this.className = className;
    }

    @Override
    public Object invoke(Supplier<Handle> handle, Object target, Object[] args, Method method) {
        return this.className + '@' + Integer.toHexString(target.hashCode());
    }

    static Map<Method, Handler> handler(String className) {
        try {
            HashMap<Method, Handler> handler = new HashMap<Method, Handler>();
            handler.put(Object.class.getMethod("toString", new Class[0]), new ToStringHandler(className));
            return handler;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("JVM error", e);
        }
    }
}

