/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.spring;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jdbi.v3.core.ConnectionFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class SpringConnectionFactory
implements ConnectionFactory {
    private final DataSource dataSource;

    public SpringConnectionFactory(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection openConnection() throws SQLException {
        return DataSourceUtils.getConnection((DataSource)this.dataSource);
    }

    public void closeConnection(Connection connection) throws SQLException {
        DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
    }
}

