/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.spring4;

import java.util.HashSet;
import java.util.Set;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JdbiUtil {
    private static final Set<Handle> TRANSACTIONAL_HANDLES = new HashSet<Handle>();

    public static Handle getHandle(Jdbi dbi) {
        Handle bound = (Handle)TransactionSynchronizationManager.getResource((Object)dbi);
        if (bound == null) {
            bound = dbi.open();
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                TransactionSynchronizationManager.bindResource((Object)dbi, (Object)bound);
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new Adapter(dbi, bound));
                TRANSACTIONAL_HANDLES.add(bound);
            }
        }
        return bound;
    }

    public static void closeIfNeeded(Handle h) {
        if (!TRANSACTIONAL_HANDLES.contains(h)) {
            h.close();
        }
    }

    private static class Adapter
    extends TransactionSynchronizationAdapter {
        private final Jdbi dbi;
        private final Handle handle;

        Adapter(Jdbi dbi, Handle handle) {
            this.dbi = dbi;
            this.handle = handle;
        }

        public void resume() {
            TransactionSynchronizationManager.bindResource((Object)this.dbi, (Object)this.handle);
        }

        public void suspend() {
            TransactionSynchronizationManager.unbindResource((Object)this.dbi);
        }

        public void beforeCompletion() {
            TRANSACTIONAL_HANDLES.remove(this.handle);
            TransactionSynchronizationManager.unbindResource((Object)this.dbi);
        }
    }
}

